<!DOCTYPE html>
<html lang="en">

<head>
    <?php include 'inc/_top.php';?>
    <title>OITCHAU :: Plans & Pricing</title>

    <?php include 'inc/_noscript-top.php';?>
</head>

<body>
<div id="content-block">
    <!-- HEADER -->
    <header class="header">
        <?php include 'inc/_header.php';?>
    </header>

    <main>
        <section class="content-section content-section-top">
            <div class="decor decor-top-right decor-lightblue decor-top-section">
                <div class="decor-inner decor-inner-same"></div>
            </div>
            <div class="container text-center ">
                <div class="anime">
                    <div class="title-space-1 fade-top">
                        <h1 class="h1 lettering">Plans & Pricing</h1>
                        <div class="text-xl lettering">Monthly or Annual Payments and cancel any time.</div>
                    </div>

                    <ul class="as-tabs fade-top anime-delay2 text-subtitle d-flex tab-menu-wrap" data-rel="1">
                        <li><a class="tab-menu" data-rel="1">time & attendence</a></li>
                        <li class="active"><a class="tab-menu" data-rel="2">External teams</a></li>
                        <li><a class="tab-menu" data-rel="3">Expenses</a></li>
                        <li><a class="tab-menu" data-rel="4">Suite</a></li>
                    </ul>

                    <div class="tabs-output" data-rel="1">
                        <div class="tab-entry" data-rel="1">
                            <div class="switch-wrap fade-top anime-delay3">
                                <div class="switch">
                                    <label class="switch-item">
                                        <input class="price-multiplier" type="radio" value="1" name="switch0" checked>
                                        <span>Monthly</span>
                                    </label>
                                    <label class="switch-item">
                                        <input class="price-multiplier" type="radio" value="0.82" name="switch0">
                                        <span>Annual (Save 18%)</span>
                                    </label>
                                </div>
                            </div>

                            <div class="plans fade-top anime-delay4">
                                <div class="plans-header">
                                    <div class="plans-header-info">
                                        <div class="text">How many employees?</div>
                                        <div class="styled-input-wrapper">
                                            <img class="styled-input-icon" src="img/preloader.jpg" data-i-src="img/icons/icon-user2.svg" alt="">
                                            <input class="styled-input ranger-input number-input" type="text" data-range-rel="1">
                                        </div>
                                    </div>
                                    <div class="ranger-wrapper">
                                        <div class="ranger-wrapper-text">user</div>
                                        <div class="ranger calculate-price-ranger" data-range-rel="1" data-start="750" data-range-json='{"min": [1, 1], "20%": [100, 10], "40%": [250, 100], "70%": [1000, 250], "max": [5000, 250] }'></div>
                                    </div>
                                </div>
                                <div class="plans-body">
                                    <div class="plans-item">
                                        <div class="plans-item-top">
                                            <div class="plans-item-content">
                                                <div class="title h3">Standard</div>
                                                <div class="h2 color-secondary"><sup>R$</sup><span class="js-reg-price">8.90</span></div>
                                                <div class="w-medium">per user, per month</div>
                                                <a class="btn btn-secondary btn-h-sm" href="#">Try for free</a>
                                                <div>or <a href="#" class="inline-link">purchase now</a></div>
                                            </div>

                                            <div class="check_list-wrap">
                                                <ul class="check_list check_list-green">
                                                    <li>Punching on Mobile, Web & Tablet</li>
                                                    <li>Quisque mauris est, sagittis ac arcu</li>
                                                    <li>Efficitur, porta bibendum eros</li>
                                                    <li>Mauris libero ex pharetra a pharetra</li>
                                                    <li>Eget, fermentum scelerisque nisi</li>
                                                    <li>In ut augue a leo rhoncus ultrices</li>
                                                    <li>Etiam sollicitudin efficitur vestibulum</li>
                                                </ul>
                                            </div>
                                        </div>

                                        <div class="plans-item-bottom color-additional-lighter">
                                            and more...
                                        </div>
                                    </div>
                                    <div class="plans-item">
                                        <div class="plans-item-top">
                                            <div class="plans-item-content">
                                                <div class="title h3">Premium</div>
                                                <div class="h2 color-secondary"><sup>R$</sup><span class="js-premium-price">29</span></div>
                                                <div class="w-medium">per user, per month</div>
                                                <a class="btn btn-primary btn-h-sm" href="#">Try for free</a>
                                                <div>or <a href="#" class="inline-link">purchase now</a></div>
                                            </div>

                                            <div class="check_list-wrap">
                                                <div class="check_list-title color-primary"><b>Everything in Standard, plus</b></div>
                                                <ul class="check_list check_list-green">
                                                    <li>Quisque mauris est, sagittis ac arcu</li>
                                                    <li>Efficitur, porta bibendum eros</li>
                                                    <li>Mauris libero ex pharetra a pharetra</li>
                                                    <li>Eget, fermentum scelerisque nisi</li>
                                                    <li>In ut augue a leo rhoncus ultrices</li>
                                                </ul>
                                            </div>
                                        </div>

                                        <div class="plans-item-bottom color-additional-lighter">
                                            and more...
                                        </div>
                                    </div>
                                    <div class="plans-item">
                                        <div class="plans-item-top">
                                            <div class="plans-item-content no-inline-link">
                                                <div class="title h3">Enterprise</div>
                                                <div class="js-hide-enterprise-price">
                                                    <img class="img" src="img/preloader.jpg" data-i-src="img/enterprise.png" alt="" >
                                                </div>
                                                <div class="js-show-enterprise-price">
                                                    <div class="h2 color-secondary"><sup>R$</sup><span class="js-enterprise-price">0</span></div>
                                                    <div class="w-medium">per user, per month</div>
                                                </div>
                                                <a class="btn btn-secondary btn-h-sm" href="#">contact us</a>
                                            </div>
                                            <div class="check_list-wrap">
                                                <div class="check_list-title color-primary"><b>Everything in Premium</b></div>
                                                <ul class="check_list check_list-green">
                                                    <li>Quisque mauris est, sagittis ac arcu</li>
                                                    <li>Efficitur, porta bibendum eros</li>
                                                    <li>Mauris libero ex pharetra a pharetra</li>
                                                    <li>Eget, fermentum scelerisque nisi</li>
                                                    <li>In ut augue a leo rhoncus ultrices</li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="plans-item-bottom color-additional-lighter">
                                            and more...
                                        </div>
                                    </div>
                                </div>
                                <div class="plans-footer color-primary">
                                    Not sure which plan is right for you? Talk to our sales team!
                                    <a class="inline-link" href="tel:+552120181092"><img src="img/icons/icon-phone-orange.svg" alt="Phone icon"><span>+55-21-2018-1092</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="tab-entry active" data-rel="2" style="display:block;">
                            <div class="switch-wrap fade-top anime-delay3">
                                <div class="switch">
                                    <label class="switch-item">
                                        <input class="price-multiplier" type="radio" value="1" name="switch1" checked>
                                        <span>Monthly</span>
                                    </label>
                                    <label class="switch-item">
                                        <input class="price-multiplier" type="radio" value="0.82" name="switch1">
                                        <span>Annual (Save 18%)</span>
                                    </label>
                                </div>
                            </div>

                            <div class="plans fade-top anime-delay4">
                                <div class="plans-header">
                                    <div class="plans-header-info">
                                        <div class="text">How many employees?</div>
                                        <div class="styled-input-wrapper">
                                            <img class="styled-input-icon" src="img/preloader.jpg" data-i-src="img/icons/icon-user2.svg" alt="">
                                            <input class="styled-input ranger-input number-input" type="text" data-range-rel="2">
                                        </div>
                                    </div>
                                    <div class="ranger-wrapper">
                                        <div class="ranger-wrapper-text">user</div>
                                        <div class="ranger calculate-price-ranger" data-range-rel="2" data-start="35" data-range-json='{"min": [1, 1], "20%": [100, 10], "40%": [250, 100], "70%": [1000, 250], "max": [5000, 250] }'></div>
                                    </div>
                                </div>
                                <div class="plans-body">
                                    <div class="plans-item">
                                        <div class="plans-item-top">
                                            <div class="plans-item-content">
                                                <div class="title h3">Standard</div>
                                                <div class="h2 color-secondary"><sup>R$</sup><span class="js-reg-price">8.90</span></div>
                                                <div class="w-medium">per user, per month</div>
                                                <a class="btn btn-secondary btn-h-sm" href="#">Try for free</a>
                                                <div>or <a href="#" class="inline-link">purchase now</a></div>
                                            </div>

                                            <div class="check_list-wrap">
                                                <ul class="check_list check_list-green">
                                                    <li>Punching on Mobile, Web & Tablet</li>
                                                    <li>Quisque mauris est, sagittis ac arcu</li>
                                                    <li>Efficitur, porta bibendum eros</li>
                                                    <li>Mauris libero ex pharetra a pharetra</li>
                                                    <li>Eget, fermentum scelerisque nisi</li>
                                                    <li>In ut augue a leo rhoncus ultrices</li>
                                                    <li>Etiam sollicitudin efficitur vestibulum</li>
                                                </ul>
                                            </div>
                                        </div>

                                        <div class="plans-item-bottom color-additional-lighter">
                                            and more...
                                        </div>
                                    </div>
                                    <div class="plans-item">
                                        <div class="plans-item-top">
                                            <div class="plans-item-content">
                                                <div class="title h3">Premium</div>
                                                <div class="h2 color-secondary"><sup>R$</sup><span class="js-premium-price">29</span></div>
                                                <div class="w-medium">per user, per month</div>
                                                <a class="btn btn-primary btn-h-sm" href="#">Try for free</a>
                                                <div>or <a href="#" class="inline-link">purchase now</a></div>
                                            </div>

                                            <div class="check_list-wrap">
                                                <div class="check_list-title color-primary"><b>Everything in Standard, plus</b></div>
                                                <ul class="check_list check_list-green">
                                                    <li>Quisque mauris est, sagittis ac arcu</li>
                                                    <li>Efficitur, porta bibendum eros</li>
                                                    <li>Mauris libero ex pharetra a pharetra</li>
                                                    <li>Eget, fermentum scelerisque nisi</li>
                                                    <li>In ut augue a leo rhoncus ultrices</li>
                                                </ul>
                                            </div>
                                        </div>

                                        <div class="plans-item-bottom color-additional-lighter">
                                            and more...
                                        </div>
                                    </div>
                                    <div class="plans-item">
                                        <div class="plans-item-top">
                                            <div class="plans-item-content no-inline-link">
                                                <div class="title h3">Enterprise</div>
                                                <div class="js-hide-enterprise-price">
                                                    <img class="img" src="img/preloader.jpg" data-i-src="img/enterprise.png" alt="" >
                                                </div>
                                                <div class="js-show-enterprise-price">
                                                    <div class="h2 color-secondary"><sup>R$</sup><span class="js-enterprise-price">0</span></div>
                                                    <div class="w-medium">per user, per month</div>
                                                </div>
                                                <a class="btn btn-secondary btn-h-sm" href="#">contact us</a>
                                            </div>
                                            <div class="check_list-wrap">
                                                <div class="check_list-title color-primary"><b>Everything in Premium</b></div>
                                                <ul class="check_list check_list-green">
                                                    <li>Quisque mauris est, sagittis ac arcu</li>
                                                    <li>Efficitur, porta bibendum eros</li>
                                                    <li>Mauris libero ex pharetra a pharetra</li>
                                                    <li>Eget, fermentum scelerisque nisi</li>
                                                    <li>In ut augue a leo rhoncus ultrices</li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="plans-item-bottom color-additional-lighter">
                                            and more...
                                        </div>
                                    </div>
                                </div>
                                <div class="plans-footer color-primary">
                                    Not sure which plan is right for you? Talk to our sales team!
                                    <a class="inline-link" href="tel:+552120181092"><img src="img/icons/icon-phone-orange.svg" alt="Phone icon"><span>+55-21-2018-1092</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="tab-entry" data-rel="3">
                            <div class="switch-wrap fade-top anime-delay3">
                                <div class="switch">
                                    <label class="switch-item">
                                        <input  class="price-multiplier" type="radio" value="1"  name="switch2" checked>
                                        <span>Monthly</span>
                                    </label>
                                    <label class="switch-item">
                                        <input  class="price-multiplier" type="radio" value="0.82" name="switch2">
                                        <span>Annual (Save 18%)</span>
                                    </label>
                                </div>
                            </div>

                            <div class="plans fade-top anime-delay4">
                                <div class="plans-header">
                                    <div class="plans-header-info">
                                        <div class="text">How many employees?</div>
                                        <div class="styled-input-wrapper">
                                            <img class="styled-input-icon" src="img/preloader.jpg" data-i-src="img/icons/icon-user2.svg" alt="">
                                            <input class="styled-input ranger-input number-input" type="text" data-range-rel="3">
                                        </div>
                                    </div>
                                    <div class="ranger-wrapper">
                                        <div class="ranger-wrapper-text">user</div>
                                        <div class="ranger calculate-price-ranger" data-range-rel="3" data-start="100" data-range-json='{"min": [1, 1], "20%": [100, 10], "40%": [250, 100], "70%": [1000, 250], "max": [5000, 250] }'></div>
                                    </div>
                                </div>
                                <div class="plans-body">
                                    <div class="plans-item">
                                        <div class="plans-item-top">
                                            <div class="plans-item-content">
                                                <div class="title h3">Standard</div>
                                                <div class="h2 color-secondary"><sup>R$</sup><span class="js-reg-price">29</span></div>
                                                <div class="w-medium">per user, per month</div>
                                                <a class="btn btn-secondary btn-h-sm" href="#">Try for free</a>
                                                <div>or <a href="#" class="inline-link">purchase now</a></div>
                                            </div>

                                            <div class="check_list-wrap">
                                                <ul class="check_list check_list-green">
                                                    <li>Punching on Mobile, Web & Tablet</li>
                                                    <li>Quisque mauris est, sagittis ac arcu</li>
                                                    <li>Efficitur, porta bibendum eros</li>
                                                    <li>Mauris libero ex pharetra a pharetra</li>
                                                    <li>Eget, fermentum scelerisque nisi</li>
                                                    <li>In ut augue a leo rhoncus ultrices</li>
                                                    <li>Etiam sollicitudin efficitur vestibulum</li>
                                                </ul>
                                            </div>
                                        </div>

                                        <div class="plans-item-bottom color-additional-lighter">
                                            and more...
                                        </div>
                                    </div>
                                    <div class="plans-item">
                                        <div class="plans-item-top">
                                            <div class="plans-item-content">
                                                <div class="title h3">Premium</div>
                                                <div class="h2 color-secondary"><sup>R$</sup><span class="js-premium-price">29</span></div>
                                                <div class="w-medium">per user, per month</div>
                                                <a class="btn btn-primary btn-h-sm" href="#">Try for free</a>
                                                <div>or <a href="#" class="inline-link">purchase now</a></div>
                                            </div>

                                            <div class="check_list-wrap">
                                                <div class="check_list-title color-primary"><b>Everything in Standard, plus</b></div>
                                                <ul class="check_list check_list-green">
                                                    <li>Quisque mauris est, sagittis ac arcu</li>
                                                    <li>Efficitur, porta bibendum eros</li>
                                                    <li>Mauris libero ex pharetra a pharetra</li>
                                                    <li>Eget, fermentum scelerisque nisi</li>
                                                    <li>In ut augue a leo rhoncus ultrices</li>
                                                </ul>
                                            </div>
                                        </div>

                                        <div class="plans-item-bottom color-additional-lighter">
                                            and more...
                                        </div>
                                    </div>
                                    <div class="plans-item">
                                        <div class="plans-item-top">
                                            <div class="plans-item-content no-inline-link">
                                                <div class="title h3">Enterprise</div>
                                                <div class="js-hide-enterprise-price">
                                                    <img class="img" src="img/preloader.jpg" data-i-src="img/enterprise.png" alt="" >
                                                </div>
                                                <div class="js-show-enterprise-price">
                                                    <div class="h2 color-secondary"><sup>R$</sup><span class="js-enterprise-price">0</span></div>
                                                    <div class="w-medium">per user, per month</div>
                                                </div>
                                                <a class="btn btn-secondary btn-h-sm" href="#">contact us</a>
                                            </div>
                                            <div class="check_list-wrap">
                                                <div class="check_list-title color-primary"><b>Everything in Premium</b></div>
                                                <ul class="check_list check_list-green">
                                                    <li>Quisque mauris est, sagittis ac arcu</li>
                                                    <li>Efficitur, porta bibendum eros</li>
                                                    <li>Mauris libero ex pharetra a pharetra</li>
                                                    <li>Eget, fermentum scelerisque nisi</li>
                                                    <li>In ut augue a leo rhoncus ultrices</li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="plans-item-bottom color-additional-lighter">
                                            and more...
                                        </div>
                                    </div>
                                </div>
                                <div class="plans-footer color-primary">
                                    Not sure which plan is right for you? Talk to our sales team!
                                    <a class="inline-link" href="tel:+552120181092"><img src="img/icons/icon-phone-orange.svg" alt="Phone icon"><span>+55-21-2018-1092</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="tab-entry" data-rel="4">
                            <div class="switch-wrap fade-top anime-delay3">
                                <div class="switch">
                                    <label class="switch-item">
                                        <input  class="price-multiplier" type="radio" value="1" name="switch3">
                                        <span>Monthly</span>
                                    </label>
                                    <label class="switch-item">
                                        <input  class="price-multiplier" type="radio" value="0.82" name="switch3" checked>
                                        <span>Annual (Save 18%)</span>
                                    </label>
                                </div>
                            </div>

                            <div class="plans fade-top anime-delay4">
                                <div class="plans-header">
                                    <div class="plans-header-info">
                                        <div class="text">How many employees?</div>
                                        <div class="styled-input-wrapper">
                                            <img class="styled-input-icon" src="img/preloader.jpg" data-i-src="img/icons/icon-user2.svg" alt="">
                                            <input class="styled-input ranger-input number-input" type="text" data-range-rel="4">
                                        </div>
                                    </div>
                                    <div class="ranger-wrapper">
                                        <div class="ranger-wrapper-text">user</div>
                                        <div class="ranger calculate-price-ranger" data-range-rel="4" data-start="5000" data-range-json='{"min": [1, 1], "20%": [100, 10], "40%": [250, 100], "70%": [1000, 250], "max": [5000, 250] }'></div>
                                    </div>
                                </div>
                                <div class="plans-body">
                                    <div class="plans-item">
                                        <div class="plans-item-top">
                                            <div class="plans-item-content">
                                                <div class="title h3">Standard</div>
                                                <div class="h2 color-secondary"><sup>R$</sup><span class="js-reg-price">8.90</span></div>
                                                <div class="w-medium">per user, per month</div>
                                                <a class="btn btn-secondary btn-h-sm" href="#">Try for free</a>
                                                <div>or <a href="#" class="inline-link">purchase now</a></div>
                                            </div>

                                            <div class="check_list-wrap">
                                                <ul class="check_list check_list-green">
                                                    <li>Punching on Mobile, Web & Tablet</li>
                                                    <li>Quisque mauris est, sagittis ac arcu</li>
                                                    <li>Efficitur, porta bibendum eros</li>
                                                    <li>Mauris libero ex pharetra a pharetra</li>
                                                    <li>Eget, fermentum scelerisque nisi</li>
                                                    <li>In ut augue a leo rhoncus ultrices</li>
                                                    <li>Etiam sollicitudin efficitur vestibulum</li>
                                                </ul>
                                            </div>
                                        </div>

                                        <div class="plans-item-bottom color-additional-lighter">
                                            and more...
                                        </div>
                                    </div>
                                    <div class="plans-item">
                                        <div class="plans-item-top">
                                            <div class="plans-item-content">
                                                <div class="title h3">Premium</div>
                                                <div class="h2 color-secondary"><sup>R$</sup><span class="js-premium-price">29</span></div>
                                                <div class="w-medium">per user, per month</div>
                                                <a class="btn btn-primary btn-h-sm" href="#">Try for free</a>
                                                <div>or <a href="#" class="inline-link">purchase now</a></div>
                                            </div>

                                            <div class="check_list-wrap">
                                                <div class="check_list-title color-primary"><b>Everything in Standard, plus</b></div>
                                                <ul class="check_list check_list-green">
                                                    <li>Quisque mauris est, sagittis ac arcu</li>
                                                    <li>Efficitur, porta bibendum eros</li>
                                                    <li>Mauris libero ex pharetra a pharetra</li>
                                                    <li>Eget, fermentum scelerisque nisi</li>
                                                    <li>In ut augue a leo rhoncus ultrices</li>
                                                </ul>
                                            </div>
                                        </div>

                                        <div class="plans-item-bottom color-additional-lighter">
                                            and more...
                                        </div>
                                    </div>
                                    <div class="plans-item">
                                        <div class="plans-item-top">
                                            <div class="plans-item-content no-inline-link">
                                                <div class="title h3">Enterprise</div>
                                                <div class="js-hide-enterprise-price">
                                                    <img class="img" src="img/preloader.jpg" data-i-src="img/enterprise.png" alt="" >
                                                </div>
                                                <div class="js-show-enterprise-price">
                                                    <div class="h2 color-secondary"><sup>R$</sup><span class="js-enterprise-price">0</span></div>
                                                    <div class="w-medium">per user, per month</div>
                                                </div>
                                                <a class="btn btn-secondary btn-h-sm" href="#">contact us</a>
                                            </div>
                                            <div class="check_list-wrap">
                                                <div class="check_list-title color-primary"><b>Everything in Premium</b></div>
                                                <ul class="check_list check_list-green">
                                                    <li>Quisque mauris est, sagittis ac arcu</li>
                                                    <li>Efficitur, porta bibendum eros</li>
                                                    <li>Mauris libero ex pharetra a pharetra</li>
                                                    <li>Eget, fermentum scelerisque nisi</li>
                                                    <li>In ut augue a leo rhoncus ultrices</li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="plans-item-bottom color-additional-lighter">
                                            and more...
                                        </div>
                                    </div>
                                </div>
                                <div class="plans-footer color-primary">
                                    Not sure which plan is right for you? Talk to our sales team!
                                    <a class="inline-link" href="tel:+552120181092"><img src="img/icons/icon-phone-orange.svg" alt="Phone icon"><span>+55-21-2018-1092</span></a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>

        <div class="tabs-output" data-rel="1">
            <div class="tab-entry" data-rel="1">
                <div class="content-section d-none d-lg-block">
                    <div class="container anime">
                        <div class="plan-table-wrap fade-top ">
                            <table class="plan-table">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>
                                            <div class="h5 title">Standard <span class="color-secondary"><sup> R$</sup>8.90</span></div>
                                            <div class="text w-medium">per user, per month</div>
                                        </th>
                                        <th>
                                            <div class="h5 title">Premium <span class="color-secondary"><sup> R$</sup>29</span></div>
                                            <div class="text w-medium">per user, per month</div>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <div class="h5 main-title">Main Title</div>
                                        </td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Essentials
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Unlimited free viewers
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Unlimited boards
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Over 20 colum types
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Quisque mauris est
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Efficitur porta bibendum
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="text">50 GB</div>
                                        </td>
                                        <td>
                                            <div class="text">Unlimited</div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Mauris libero ex pharetra
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="text">Unlimited</div>
                                        </td>
                                        <td>
                                            <div class="text">Unlimited</div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="h5 main-title">Main Title</div>
                                        </td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Essentials
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Unlimited free viewers
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Unlimited boards
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Over 20 colum types
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Quisque mauris est
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Efficitur porta bibendum
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="info-line">
                                                <div class="text">
                                                    Mauris libero ex pharetra
                                                </div>
                                                <div class="info-icon" title="Message"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                        <td>
                                            <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                        </td>
                                    </tr>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td></td>
                                        <td>
                                            <div class="title h5">Standart</div>
                                            <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                            <div class="text">or <a class="inline-link" href="#">purchase now</a></div>
                                        </td>
                                        <td>
                                            <div class="title h5">Premium</div>
                                            <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                            <div class="text">or <a class="inline-link" href="#">purchase now</a></div>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="content-section content-space-1 sm-p-0">
                    <div class="container text-center">
                        <div class="anime">
                            <div class="partners_wrap color-additional-lighter fade-top">
                                <div class="text-subtitle content-subtitle">Loved & Trusted by</div>
                                <ul class="partners_list text-sm">
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted1.png" alt="Zup logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted2.png" alt="Dog hero logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted3.png" alt="Clearsale logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted4.png" alt="Group logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted5.png" alt="Quintoandar logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted6.png" alt="AEB logo"></li>
                                    <li><b>Over 100,000<br>employees</b></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="content-section content-space-7">
                    <div class="decor decor-half decor-bottom-left decor-orange">
                        <div class="decor-inner decor-inner-same"></div>
                        <div class="decor-inner decor-inner-angle"></div>
                    </div>
                    <div class="container">
                        <div class="row m50-xxl anime">
                            <div class="col-10 col-sm-8 col-lg-5 order-lg-2 align-self-center">
                                <div class="item1 fade-top">
                                    <h2 class="h3 item1_title">Oitchau For Good</h2>
                                    <div class="article text">
                                        <p>Nam in ipsum malesuada, varius orci eget, convallis mauris. Nam convallis, justo eleifend dignissim interdum, tortor turpis convallis erat, non sollicitudin sem enim sed ex. Cras rutrum nisi nunc, at scelerisque lacus mollis maximus. Phasellus sollicitudin.</p>
                                    </div>
                                    <a class="inline-link" href="#"><span>Oitchau for Non-profits</span> <img src="img/preloader.jpg" data-i-src="img/icons/icon-arrow.svg" alt="Phone icon"></a>
                                </div>
                            </div>
                            <div class="col-sm-5 col-lg-7 order-lg-1">
                                <img class="img item1_img-main item1_img-main2 fade-top anime-delay1" src="img/preloader.jpg" data-i-md-src="img/girl-image.png" alt="Time Off & Requests">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="content-section content-space-5">
                    <div class="container anime">
                        <div class="h3 title-space-1 text-center fade-top">Frequently Asked Questions</div>

                        <div class="accordeon fade-top anime-delay1">
                            <div class="accordeon-entry active">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle" style="display:block;">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                            <div class="accordeon-entry">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                            <div class="accordeon-entry">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                            <div class="accordeon-entry">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-entry active" data-rel="2" style="display:block;">
                <div class="content-section d-none d-lg-block">
                    <div class="container anime">
                        <div class="plan-table-wrap fade-top ">
                            <table class="plan-table">
                                <thead>
                                <tr>
                                    <th></th>
                                    <th>
                                        <div class="h5 title">Standard <span class="color-secondary"><sup> R$</sup>8.90</span></div>
                                        <div class="text w-medium">per user, per month</div>
                                    </th>
                                    <th>
                                        <div class="h5 title">Premium <span class="color-secondary"><sup> R$</sup>29</span></div>
                                        <div class="text w-medium">per user, per month</div>
                                    </th>
                                    <th>
                                        <div class="h5 title">Enterprise</div>
                                        <div class="text w-medium">custom pricing</div>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td>
                                        <div class="h5 main-title">Main Title</div>
                                    </td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Essentials
                                            </div>
                                            <div class="info-icon">
                                                <div class="info-tooltip">
                                                    All tools available for unlimited time
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Unlimited free viewers
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Unlimited boards
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Over 20 colum types
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Quisque mauris est
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Efficitur porta bibendum
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="text">50 GB</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Mauris libero ex pharetra
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="h5 main-title">Main Title</div>
                                    </td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Essentials
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Unlimited free viewers
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Unlimited boards
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Over 20 colum types
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Quisque mauris est
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Efficitur porta bibendum
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Mauris libero ex pharetra
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td></td>
                                    <td>
                                        <div class="title h5">Standart</div>
                                        <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                        <div class="text">or <a class="inline-link" href="#">purchase now</a></div>
                                    </td>
                                    <td>
                                        <div class="title h5">Premium</div>
                                        <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                        <div class="text">or <a class="inline-link" href="#">purchase now</a></div>
                                    </td>
                                    <td>
                                        <div class="title h5">Enterprise</div>
                                        <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="content-section content-space-1 sm-p-0">
                    <div class="container text-center">
                        <div class="anime">
                            <div class="partners_wrap color-additional-lighter fade-top">
                                <div class="text-subtitle content-subtitle">Loved & Trusted by</div>
                                <ul class="partners_list text-sm">
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted1.png" alt="Zup logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted2.png" alt="Dog hero logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted3.png" alt="Clearsale logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted4.png" alt="Group logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted5.png" alt="Quintoandar logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted6.png" alt="AEB logo"></li>
                                    <li><b>Over 100,000<br>employees</b></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="content-section content-space-7">
                    <div class="decor decor-half decor-bottom-left decor-orange">
                        <div class="decor-inner decor-inner-same"></div>
                        <div class="decor-inner decor-inner-angle"></div>
                    </div>
                    <div class="container">
                        <div class="row m50-xxl anime">
                            <div class="col-10 col-sm-8 col-lg-5 order-lg-2 align-self-center">
                                <div class="item1 fade-top">
                                    <h2 class="h3 item1_title">Oitchau For Good</h2>
                                    <div class="article text">
                                        <p>Nam in ipsum malesuada, varius orci eget, convallis mauris. Nam convallis, justo eleifend dignissim interdum, tortor turpis convallis erat, non sollicitudin sem enim sed ex. Cras rutrum nisi nunc, at scelerisque lacus mollis maximus. Phasellus sollicitudin.</p>
                                    </div>
                                    <a class="inline-link" href="#"><span>Oitchau for Non-profits</span> <img src="img/preloader.jpg" data-i-src="img/icons/icon-arrow.svg" alt="Phone icon"></a>
                                </div>
                            </div>
                            <div class="col-sm-5 col-lg-7 order-lg-1">
                                <img class="img item1_img-main item1_img-main2 fade-top anime-delay1" src="img/preloader.jpg" data-i-md-src="img/girl-image.png" alt="Time Off & Requests">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="content-section content-space-5">
                    <div class="container anime">
                        <div class="h3 title-space-1 text-center fade-top">Frequently Asked Questions</div>

                        <div class="accordeon fade-top anime-delay1">
                            <div class="accordeon-entry active">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle" style="display:block;">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                            <div class="accordeon-entry">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                            <div class="accordeon-entry">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                            <div class="accordeon-entry">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-entry" data-rel="3">
                <div class="content-section d-none d-lg-block">
                    <div class="container anime">
                        <div class="plan-table-wrap fade-top ">
                            <table class="plan-table">
                                <thead>
                                <tr>
                                    <th></th>
                                    <th>
                                        <div class="h5 title">Standard <span class="color-secondary"><sup> R$</sup>8.90</span></div>
                                        <div class="text w-medium">per user, per month</div>
                                    </th>
                                    <th>
                                        <div class="h5 title">Premium <span class="color-secondary"><sup> R$</sup>29</span></div>
                                        <div class="text w-medium">per user, per month</div>
                                    </th>
                                    <th>
                                        <div class="h5 title">Enterprise</div>
                                        <div class="text w-medium">custom pricing</div>
                                    </th>
                                    <th>
                                        <div class="h5 title">Enterprise</div>
                                        <div class="text w-medium">custom pricing</div>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td>
                                        <div class="h5 main-title">Main Title</div>
                                    </td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Essentials
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Unlimited free viewers
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Unlimited boards
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Over 20 colum types
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Quisque mauris est
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Efficitur porta bibendum
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="text">50 GB</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Mauris libero ex pharetra
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="h5 main-title">Main Title</div>
                                    </td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Essentials
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Unlimited free viewers
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Unlimited boards
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Over 20 colum types
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Quisque mauris est
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Efficitur porta bibendum
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Mauris libero ex pharetra
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td></td>
                                    <td>
                                        <div class="title h5">Standart</div>
                                        <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                        <div class="text">or <a class="inline-link" href="#">purchase now</a></div>
                                    </td>
                                    <td>
                                        <div class="title h5">Premium</div>
                                        <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                        <div class="text">or <a class="inline-link" href="#">purchase now</a></div>
                                    </td>
                                    <td>
                                        <div class="title h5">Enterprise</div>
                                        <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                    </td>
                                    <td>
                                        <div class="title h5">Enterprise</div>
                                        <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="content-section content-space-1 sm-p-0">
                    <div class="container text-center">
                        <div class="anime">
                            <div class="partners_wrap color-additional-lighter fade-top">
                                <div class="text-subtitle content-subtitle">Loved & Trusted by</div>
                                <ul class="partners_list text-sm">
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted1.png" alt="Zup logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted2.png" alt="Dog hero logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted3.png" alt="Clearsale logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted4.png" alt="Group logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted5.png" alt="Quintoandar logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted6.png" alt="AEB logo"></li>
                                    <li><b>Over 100,000<br>employees</b></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="content-section content-space-7">
                    <div class="decor decor-half decor-bottom-left decor-orange">
                        <div class="decor-inner decor-inner-same"></div>
                        <div class="decor-inner decor-inner-angle"></div>
                    </div>
                    <div class="container">
                        <div class="row m50-xxl anime">
                            <div class="col-10 col-sm-8 col-lg-5 order-lg-2 align-self-center">
                                <div class="item1 fade-top">
                                    <h2 class="h3 item1_title">Oitchau For Good</h2>
                                    <div class="article text">
                                        <p>Nam in ipsum malesuada, varius orci eget, convallis mauris. Nam convallis, justo eleifend dignissim interdum, tortor turpis convallis erat, non sollicitudin sem enim sed ex. Cras rutrum nisi nunc, at scelerisque lacus mollis maximus. Phasellus sollicitudin.</p>
                                    </div>
                                    <a class="inline-link" href="#"><span>Oitchau for Non-profits</span> <img src="img/preloader.jpg" data-i-src="img/icons/icon-arrow.svg" alt="Phone icon"></a>
                                </div>
                            </div>
                            <div class="col-sm-5 col-lg-7 order-lg-1">
                                <img class="img item1_img-main item1_img-main2 fade-top anime-delay1" src="img/preloader.jpg" data-i-md-src="img/girl-image.png" alt="Time Off & Requests">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="content-section content-space-5">
                    <div class="container anime">
                        <div class="h3 title-space-1 text-center fade-top">Frequently Asked Questions</div>

                        <div class="accordeon fade-top anime-delay1">
                            <div class="accordeon-entry active">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle" style="display:block;">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                            <div class="accordeon-entry">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                            <div class="accordeon-entry">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                            <div class="accordeon-entry">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-entry" data-rel="4">
                <div class="content-section d-none d-lg-block">
                    <div class="container anime">
                        <div class="plan-table-wrap fade-top ">
                            <table class="plan-table">
                                <thead>
                                <tr>
                                    <th></th>
                                    <th>
                                        <div class="h5 title">Standard <span class="color-secondary"><sup> R$</sup>8.90</span></div>
                                        <div class="text w-medium">per user, per month</div>
                                    </th>
                                    <th>
                                        <div class="h5 title">Premium <span class="color-secondary"><sup> R$</sup>29</span></div>
                                        <div class="text w-medium">per user, per month</div>
                                    </th>
                                    <th>
                                        <div class="h5 title">Enterprise</div>
                                        <div class="text w-medium">custom pricing</div>
                                    </th>
                                    <th>
                                        <div class="h5 title">Enterprise</div>
                                        <div class="text w-medium">custom pricing</div>
                                    </th>
                                    <th>
                                        <div class="h5 title">Enterprise</div>
                                        <div class="text w-medium">custom pricing</div>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td>
                                        <div class="h5 main-title">Main Title</div>
                                    </td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Essentials
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Unlimited free viewers
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Unlimited boards
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Over 20 colum types
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Quisque mauris est
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Efficitur porta bibendum
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="text">50 GB</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Mauris libero ex pharetra
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                    <td>
                                        <div class="text">Unlimited</div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="h5 main-title">Main Title</div>
                                    </td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Essentials
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Unlimited free viewers
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Unlimited boards
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Over 20 colum types
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Quisque mauris est
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Efficitur porta bibendum
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="info-line">
                                            <div class="text">
                                                Mauris libero ex pharetra
                                            </div>
                                            <div class="info-icon" title="Message"></div>
                                        </div>
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                    <td>
                                        <img class="img" src="img/preloader.jpg" data-i-src="img/icons/icon-checked-green-full.svg" alt="">
                                    </td>
                                </tr>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td></td>
                                    <td>
                                        <div class="title h5">Standart</div>
                                        <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                        <div class="text">or <a class="inline-link" href="#">purchase now</a></div>
                                    </td>
                                    <td>
                                        <div class="title h5">Premium</div>
                                        <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                        <div class="text">or <a class="inline-link" href="#">purchase now</a></div>
                                    </td>
                                    <td>
                                        <div class="title h5">Enterprise</div>
                                        <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                    </td>
                                    <td>
                                        <div class="title h5">Enterprise</div>
                                        <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                    </td>
                                    <td>
                                        <div class="title h5">Enterprise</div>
                                        <a class="btn btn-purple btn-h-sm " href="#">Try for free</a>
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="content-section content-space-1 sm-p-0">
                    <div class="container text-center">
                        <div class="anime">
                            <div class="partners_wrap color-additional-lighter fade-top">
                                <div class="text-subtitle content-subtitle">Loved & Trusted by</div>
                                <ul class="partners_list text-sm">
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted1.png" alt="Zup logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted2.png" alt="Dog hero logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted3.png" alt="Clearsale logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted4.png" alt="Group logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted5.png" alt="Quintoandar logo"></li>
                                    <li><img class="img" src="img/preloader.jpg" data-i-src="img/trusted6.png" alt="AEB logo"></li>
                                    <li><b>Over 100,000<br>employees</b></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="content-section content-space-7">
                    <div class="decor decor-half decor-bottom-left decor-orange">
                        <div class="decor-inner decor-inner-same"></div>
                        <div class="decor-inner decor-inner-angle"></div>
                    </div>
                    <div class="container">
                        <div class="row m50-xxl anime">
                            <div class="col-10 col-sm-8 col-lg-5 order-lg-2 align-self-center">
                                <div class="item1 fade-top">
                                    <h2 class="h3 item1_title">Oitchau For Good</h2>
                                    <div class="article text">
                                        <p>Nam in ipsum malesuada, varius orci eget, convallis mauris. Nam convallis, justo eleifend dignissim interdum, tortor turpis convallis erat, non sollicitudin sem enim sed ex. Cras rutrum nisi nunc, at scelerisque lacus mollis maximus. Phasellus sollicitudin.</p>
                                    </div>
                                    <a class="inline-link" href="#"><span>Oitchau for Non-profits</span> <img src="img/preloader.jpg" data-i-src="img/icons/icon-arrow.svg" alt="Phone icon"></a>
                                </div>
                            </div>
                            <div class="col-sm-5 col-lg-7 order-lg-1">
                                <img class="img item1_img-main item1_img-main2 fade-top anime-delay1" src="img/preloader.jpg" data-i-md-src="img/girl-image.png" alt="Time Off & Requests">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="content-section content-space-5">
                    <div class="container anime">
                        <div class="h3 title-space-1 text-center fade-top">Frequently Asked Questions</div>

                        <div class="accordeon fade-top anime-delay1">
                            <div class="accordeon-entry active">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle" style="display:block;">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                            <div class="accordeon-entry">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                            <div class="accordeon-entry">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                            <div class="accordeon-entry">
                                <div class="accordeon-title color-primary text-lg">
                                    <b>What are my payment options - credit card and/or invoicing?</b>
                                </div>
                                <div class="accordeon-toggle">
                                    <div class="article text">
                                        <p>Cras eu finibus eros. Sed tempor magna ante, vel tempor dui facilisis tincidunt. Morbi nec dictum ex. Donec vestibulum turpis lectus, ut malesuada orci pellentesque in</p>
                                    </div>
                                </div>
                                <button class="accordeon-button"></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <section class="content-section content-space-1">
            <div class="container">
                <div class="row anime">
                    <div class="col-lg-8 offset-lg-2 text-center">
                        <div class="text-subtitle content-subtitle color-secondary fade-top">Prices start just at $89/mo</div>
                        <h3 class="h3 title-space-1 fade-top anime-delay1">Join our thousands of happy customers who manage their team with Oitchau.</h3>
                        <div class="fade-top anime-delay2">
                            <a class="btn btn-optional" href="#">Register for Free</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </main>

    <!-- FOOTER -->
    <footer class="footer">
        <?php include 'inc/_footer.php';?>
    </footer>
</div>

<!-- POPUPS -->
<?php include 'inc/_popups.php';?>
<?php include 'inc/_bottom.php';?>
<?php include 'inc/_lettering-scripts.php';?>

<!-- price-employees data -->
<script>
    var priceDataJson = {
        'pricing1': [
            {
                'employees': [0, 10],
                'price-reg': 8.90,
                'price-prem': 29
            },
            {
                'employees': [11, 25],
                'price-reg': 6.36,
                'price-prem': 29
            },
            {
                'employees': [26, 50],
                'price-reg': 5.00,
                'price-prem': 29
            },
            {
                'employees': [51, 75],
                'price-reg': 5.00,
                'price-prem': 28
            },
            {
                'employees': [76, 100],
                'price-reg': 5.00,
                'price-prem': 27
            },
            {
                'employees': [101, 150],
                'price-reg': 5.00,
                'price-prem': 26
            },
            {
                'employees': [151, 200],
                'price-reg': 5.00,
                'price-prem': 25
            },
            {
                'employees': [201, 250],
                'price-reg': 5.00,
                'price-prem': 24
            },
            {
                'employees': [251, 300],
                'price-reg': 5.00,
                'price-prem': 23
            },
            {
                'employees': [301, 350],
                'price-reg': 5.00,
                'price-prem': 22
            },
            {
                'employees': [351, 400],
                'price-reg': 5.00,
                'price-prem': 21
            },
            {
                'employees': [401, 500],
                'price-reg': 5.00,
                'price-prem': 20
            },
            {
                'employees': [501, 600],
                'price-reg': 5.00,
                'price-prem': 19
            },
            {
                'employees': [601, 700],
                'price-reg': 4.85,
                'price-prem': 18
            },
            {
                'employees': [701, 800],
                'price-reg': 4.70,
                'price-prem': 17
            },
            {
                'employees': [801, 900],
                'price-reg': 4.55,
                'price-prem': 16
            },
            {
                'employees': [901, 1000],
                'price-reg': 4.40,
                'price-prem': 15
            },
            {
                'employees': [1001, 1500],
                'price-reg': 4.25,
                'price-prem': 14,
                'price-enterprise': 40
            },
            {
                'employees': [1501, 2000],
                'price-reg': 4.10,
                'price-prem': 12,
                'price-enterprise': 35
            },
            {
                'employees': [2001, 3000],
                'price-reg': 3.95,
                'price-prem': 11,
                'price-enterprise': 33
            },
            {
                'employees': [3001, 4000],
                'price-reg': 3.80,
                'price-prem': 10,
                'price-enterprise': 30
            },
            {
                'employees': [4001, 5000],
                'price-reg': 3.65,
                'price-prem': 9,
                'price-enterprise': 25
            }
        ],
        'pricing2': [
            {
                'employees': [0, 10],
                'price-reg': 8.90,
                'price-prem': 29
            },
            {
                'employees': [11, 25],
                'price-reg': 6.36,
                'price-prem': 29
            },
            {
                'employees': [26, 50],
                'price-reg': 5.00,
                'price-prem': 29
            },
            {
                'employees': [51, 75],
                'price-reg': 5.00,
                'price-prem': 28
            },
            {
                'employees': [76, 100],
                'price-reg': 5.00,
                'price-prem': 27
            },
            {
                'employees': [101, 150],
                'price-reg': 5.00,
                'price-prem': 26
            },
            {
                'employees': [151, 200],
                'price-reg': 5.00,
                'price-prem': 25
            },
            {
                'employees': [201, 250],
                'price-reg': 5.00,
                'price-prem': 24
            },
            {
                'employees': [251, 300],
                'price-reg': 5.00,
                'price-prem': 23
            },
            {
                'employees': [301, 350],
                'price-reg': 5.00,
                'price-prem': 22
            },
            {
                'employees': [351, 400],
                'price-reg': 5.00,
                'price-prem': 21
            },
            {
                'employees': [401, 500],
                'price-reg': 5.00,
                'price-prem': 20
            },
            {
                'employees': [501, 600],
                'price-reg': 5.00,
                'price-prem': 19
            },
            {
                'employees': [601, 700],
                'price-reg': 4.85,
                'price-prem': 18
            },
            {
                'employees': [701, 800],
                'price-reg': 4.70,
                'price-prem': 17
            },
            {
                'employees': [801, 900],
                'price-reg': 4.55,
                'price-prem': 16
            },
            {
                'employees': [901, 1000],
                'price-reg': 4.40,
                'price-prem': 15
            },
            {
                'employees': [1001, 1500],
                'price-reg': 4.25,
                'price-prem': 14,
                'price-enterprise': 40
            },
            {
                'employees': [1501, 2000],
                'price-reg': 4.10,
                'price-prem': 12,
                'price-enterprise': 35
            },
            {
                'employees': [2001, 3000],
                'price-reg': 3.95,
                'price-prem': 11,
                'price-enterprise': 33
            },
            {
                'employees': [3001, 4000],
                'price-reg': 3.80,
                'price-prem': 10,
                'price-enterprise': 30
            },
            {
                'employees': [4001, 5000],
                'price-reg': 3.65,
                'price-prem': 9,
                'price-enterprise': 25
            }
        ],
        'pricing3': [
            {
                'employees': [0, 10],
                'price-reg': 8.90,
                'price-prem': 29
            },
            {
                'employees': [11, 25],
                'price-reg': 6.36,
                'price-prem': 29
            },
            {
                'employees': [26, 50],
                'price-reg': 5.00,
                'price-prem': 29
            },
            {
                'employees': [51, 75],
                'price-reg': 5.00,
                'price-prem': 28
            },
            {
                'employees': [76, 100],
                'price-reg': 5.00,
                'price-prem': 27
            },
            {
                'employees': [101, 150],
                'price-reg': 5.00,
                'price-prem': 26
            },
            {
                'employees': [151, 200],
                'price-reg': 5.00,
                'price-prem': 25
            },
            {
                'employees': [201, 250],
                'price-reg': 5.00,
                'price-prem': 24
            },
            {
                'employees': [251, 300],
                'price-reg': 5.00,
                'price-prem': 23
            },
            {
                'employees': [301, 350],
                'price-reg': 5.00,
                'price-prem': 22
            },
            {
                'employees': [351, 400],
                'price-reg': 5.00,
                'price-prem': 21
            },
            {
                'employees': [401, 500],
                'price-reg': 5.00,
                'price-prem': 20
            },
            {
                'employees': [501, 600],
                'price-reg': 5.00,
                'price-prem': 19
            },
            {
                'employees': [601, 700],
                'price-reg': 4.85,
                'price-prem': 18
            },
            {
                'employees': [701, 800],
                'price-reg': 4.70,
                'price-prem': 17
            },
            {
                'employees': [801, 900],
                'price-reg': 4.55,
                'price-prem': 16
            },
            {
                'employees': [901, 1000],
                'price-reg': 4.40,
                'price-prem': 15
            },
            {
                'employees': [1001, 1500],
                'price-reg': 4.25,
                'price-prem': 14,
                'price-enterprise': 40
            },
            {
                'employees': [1501, 2000],
                'price-reg': 4.10,
                'price-prem': 12,
                'price-enterprise': 35
            },
            {
                'employees': [2001, 3000],
                'price-reg': 3.95,
                'price-prem': 11,
                'price-enterprise': 33
            },
            {
                'employees': [3001, 4000],
                'price-reg': 3.80,
                'price-prem': 10,
                'price-enterprise': 30
            },
            {
                'employees': [4001, 5000],
                'price-reg': 3.65,
                'price-prem': 9,
                'price-enterprise': 25
            }
        ],
        'pricing4': [
            {
                'employees': [0, 10],
                'price-reg': 8.90,
                'price-prem': 29
            },
            {
                'employees': [11, 25],
                'price-reg': 6.36,
                'price-prem': 29
            },
            {
                'employees': [26, 50],
                'price-reg': 5.00,
                'price-prem': 29
            },
            {
                'employees': [51, 75],
                'price-reg': 5.00,
                'price-prem': 28
            },
            {
                'employees': [76, 100],
                'price-reg': 5.00,
                'price-prem': 27
            },
            {
                'employees': [101, 150],
                'price-reg': 5.00,
                'price-prem': 26
            },
            {
                'employees': [151, 200],
                'price-reg': 5.00,
                'price-prem': 25
            },
            {
                'employees': [201, 250],
                'price-reg': 5.00,
                'price-prem': 24
            },
            {
                'employees': [251, 300],
                'price-reg': 5.00,
                'price-prem': 23
            },
            {
                'employees': [301, 350],
                'price-reg': 5.00,
                'price-prem': 22
            },
            {
                'employees': [351, 400],
                'price-reg': 5.00,
                'price-prem': 21
            },
            {
                'employees': [401, 500],
                'price-reg': 5.00,
                'price-prem': 20
            },
            {
                'employees': [501, 600],
                'price-reg': 5.00,
                'price-prem': 19
            },
            {
                'employees': [601, 700],
                'price-reg': 4.85,
                'price-prem': 18
            },
            {
                'employees': [701, 800],
                'price-reg': 4.70,
                'price-prem': 17
            },
            {
                'employees': [801, 900],
                'price-reg': 4.55,
                'price-prem': 16
            },
            {
                'employees': [901, 1000],
                'price-reg': 4.40,
                'price-prem': 15
            },
            {
                'employees': [1001, 1500],
                'price-reg': 4.25,
                'price-prem': 14,
                'price-enterprise': 40
            },
            {
                'employees': [1501, 2000],
                'price-reg': 4.10,
                'price-prem': 12,
                'price-enterprise': 35
            },
            {
                'employees': [2001, 3000],
                'price-reg': 3.95,
                'price-prem': 11,
                'price-enterprise': 33
            },
            {
                'employees': [3001, 4000],
                'price-reg': 3.80,
                'price-prem': 10,
                'price-enterprise': 30
            },
            {
                'employees': [4001, 5000],
                'price-reg': 3.65,
                'price-prem': 9,
                'price-enterprise': 25
            }
        ]
    };
</script>

<?php include 'inc/_range-scripts-styles.php';?>

</body>

</html>