var _functions = {}, winW, winH, winScr;

jQuery(function($) {

	"use strict";
        
    /* function on page ready */
    var isTouchScreen = navigator.userAgent.match(/Android/i) || navigator.userAgent.match(/webOS/i) || navigator.userAgent.match(/iPhone/i) || navigator.userAgent.match(/iPad/i) || navigator.userAgent.match(/iPod/i);
    if (isTouchScreen) $('html').addClass('touch-screen');

    _functions.pageCalculations = function () {
        winW = $(window).width();
        winH = $(window).height();
    }

    _functions.pageCalculations();
    // setTimeout(_functions.pageCalculations, 0);

    //images preload
    setTimeout(function() {

        /* images load */
        $('img[data-i-src], iframe[data-i-src]').each(function (i, el) {
            $(el).attr({'src': $(el).data('i-src')}).addClass('imgLoaded');
        });

        $('[data-bg]').each(function (i, el) {
            $(el).css({'background-image': 'url(' + $(el).data('bg') + ')'});
        });

        if (winW > 767) {
            $('img[data-i-md-src], iframe[data-i-md-src]').each(function (i, el) {
                $(el).attr({'src': $(el).data('i-md-src')}).addClass('imgLoaded');
            });
        }

    }, 100);

	/* function on page scroll */
	$(window).scroll(function(){
		_functions.scrollCall();
	});

    _functions.scrollCall = function() {
        winScr = $(window).scrollTop();
        if (winScr > 50) {
            $('header').addClass('scrolled');
        } else {
            $('header').removeClass('scrolled');
        }

        _functions.customAnimation();
    }

    setTimeout(_functions.scrollCall, 0);

    //animation
    _functions.customAnimation = function () {
        if ($('.anime').length) {
            $('.anime').not('.animated').each(function () {
                if (winScr >= $(this).offset().top - (winH * 0.95)) {
                    $(this).addClass('animated');
                }
            });
        }
    };

	/* swiper sliders */
	_functions.getSwOptions = function(swiper){
		var options = swiper.data('options');
        options = (!options || typeof options !=='object') ? {} : options;
        var $p = swiper.closest('.swiper-entry');
		if(!options.pagination) options.pagination = {
            el: $p.find('.swiper-pagination')[0],
            clickable: true
        };
		if(!options.navigation) options.navigation = {
            nextEl: $p.find('.swiper-button-next')[0],
            prevEl: $p.find('.swiper-button-prev')[0]
        };
		options.preloadImages = false;
		options.lazy = {loadPrevNext: true};
		options.observer = true;
		options.observeParents = true;
		options.watchOverflow = true;
        options.centerInsufficientSlides = true;
        if(!options.speed) options.speed = 500;
		options.roundLengths = true;
        if(isTouchScreen) options.direction = "horizontal";

        if (options.customPaginationSm && winW > 767) {
            options.pagination.renderBullet = function (index, className) {
                var slide = swiper.find('.swiper-slide').eq(index);

                return '<span class="custom-bullet-wrap"><span class="' + className + ' custom-bullet">' +
                    '<span class="bullet-text">'+slide.data('bullet-text')+'</span>' +
                    '</span><span class="custom-bullet-line"></span></span></span>';
            }
        }

		return options;
	};
	_functions.initSwiper = function(el){
		var swiper = new Swiper(el[0], _functions.getSwOptions(el));
    };
    
    $('.swiper-entry .swiper-container').each(function () {
        _functions.initSwiper($(this));
    });
    $('.swiper-thumbs').each(function () {
        var top = $(this).find('.swiper-container.swiper-thumbs-top')[0].swiper,
            bottom = $(this).find('.swiper-container.swiper-thumbs-bottom')[0].swiper;
        top.thumbs.swiper = bottom;
        top.thumbs.init();
        top.thumbs.update();
    });
    $('.swiper-control').each(function () {
        var top = $(this).find('.swiper-container')[0].swiper,
            bottom = $(this).find('.swiper-container')[1].swiper;
        top.controller.control = bottom;
        bottom.controller.control = top;
    });

    $(document).on('click', '.custom-bullet-wrap', function(e) {
        var index = $(this).index() + 1;
        console.log(index);
        $(this).closest('.swiper-entry').find('.swiper-container')[0].swiper
            .slideTo(index);
    });

    if ($('.top-swiper-wrap .swiper-container').length) {
        $('.top-swiper-wrap .swiper-container')[0].swiper.on('autoplayStop', function() {
            $(this.el).closest('.swiper-entry').addClass('stop-line-animation');
        });
    }

    //popup
    var popupTop = 0;
    function removeScroll() {
        popupTop = $(window).scrollTop();
        $('html').css({
            "position": "fixed",
            "top": -$(window).scrollTop(),
            "width": "100%"
        });
    }
    function addScroll() {
        $('html').css({
            "position": "static"
        });
        window.scroll(0, popupTop);
    }
	_functions.openPopup = function(popup){
        $('.popup-content').removeClass('active');
        $(popup + ', .popup-wrapper').addClass('active');
        removeScroll();
	};

    _functions.videoPopup = function (src) {
        $('#video-popup .embed-responsive').html('<iframe src="' + src + '"></iframe>');
        _functions.openPopup('#video-popup');
    };

	_functions.closePopup = function(){
		$('.popup-wrapper, .popup-content').removeClass('active');

        // $('.popup-iframe').html('');
        $('#video-popup iframe').remove();

		addScroll();
	};

	_functions.textPopup = function(title, description){
		$('#text-popup .text-popup-title').html(title);
		$('#text-popup .text-popup-description').html(description);
		_functions.openPopup('#text-popup');
	};

    $(document).on('click', '.video-popup', function (e) {
        e.preventDefault();
        _functions.videoPopup($(this).data('src'));
    });

	$(document).on('click', '.open-popup', function(e){
		e.preventDefault();
        _functions.openPopup('.popup-content[data-rel="' + $(this).data('rel') +'"]');
	});

	$(document).on('click', '.popup-wrapper .btn-close, .popup-wrapper .layer-close', function(e){
		e.preventDefault();
		_functions.closePopup();
	});

	//menu
    var menuOpened = 0;
    $('.hamburger').on('click', function() {
        // $(this).toggleClass('active');
        $('header').toggleClass('active');

        if (winW < 991) {
            if (!menuOpened) {
                removeScroll();
                $('header').removeClass('header-hide');
                menuOpened = 1;
            } else {
                addScroll();
                menuOpened = 0;
                $('.active-mobile').each(function () {
                    $(this).removeClass('active-mobile');
                });
            }
        }
    });

    $('#close-menu').on('click', function() {
        // $('.hamburger').removeClass('active');
        $('header').removeClass('active');

        addScroll();
        menuOpened = 0;
        $('.active-mobile').each(function () {
            $(this).removeClass('active-mobile');
        });
        $('.nav_wrap').removeClass('overflow-hidden');
    });
    
    $('.nav_inner > li').on('mouseenter', function() {
        if (winW < 992) return;
        var $this = $(this),
            $wrapper = $this.closest('.inner_menu'),
            idx = $this.data('rel');

        $wrapper.find('.inner_menu-nested.active').removeClass('active');
        $wrapper.find('.inner_menu-nested[data-rel="'+idx+'"]').addClass('active');

        $this.siblings().removeClass('active');
        $this.addClass('active');
    });

    $('.nav-arr').on('click', function() {
        var $this = $(this);
        $this.toggleClass('active');

        if ( $this.siblings('.inner_menu').length ) {
            $this.siblings('.inner_menu').addClass('active-mobile');
            $('.nav_wrap').addClass('overflow-hidden');
        } else {
            var $wrapper = $this.closest('.inner_menu'),
                $parent = $this.closest('li'),
                idx = $parent.data('rel'),
                hasList = $parent.find('.inner_menu-nested').length ? true : false,
                list = $wrapper.find('.inner_menu-nested[data-rel="'+idx+'"]');

            if (!hasList) {
                $parent.append(list);
                setTimeout(function() {
                    $parent.find('.inner_menu-nested').slideDown();
                });
            } else {
                $parent.find('.inner_menu-nested').slideToggle();
            }

            // $wrapper.find('.inner_menu-nested.active-mobile').removeClass('active-mobile');
            // $wrapper.find('.inner_menu-nested[data-rel="'+idx+'"]').addClass('active-mobile');
        }
    });

    $('.back-menu').on('click', function() {
       $(this).closest('.active-mobile').removeClass('active-mobile');
        $('.nav_wrap').removeClass('overflow-hidden');
    });

    //input
    $('.input').each(function() {
        if ($(this).val()) {
            $(this).closest('.input-wrapper').addClass('dirty');
        }
    });

    $(document).on('focus', '.input', function() {
        $(this).closest('.input-wrapper').addClass('focus');
    });

    $(document).on('blur', '.input', function () {
        $(this).parent().removeClass('focus');
        if (!$(this).val()) {
            $(this).closest('.input-wrapper').removeClass('dirty');
        }
    });

    $(document).on('keyup', '.input', function () {
        $(this).closest('.input-wrapper').addClass('dirty');
    });

    // detect if user is using keyboard tab-button to navigate
    // with 'keyboard-focus' class we add default css outlines
    function keyboardFocus (e) {
        if (e.keyCode !== 9) {
            return;
        }

        switch (e.target.nodeName.toLowerCase()) {
            case 'input':
            case 'select':
            case 'textarea':
                break;
            default:
                document.documentElement.classList.add('keyboard-focus');
                document.removeEventListener('keydown', keyboardFocus, false);
        }
    }
    document.addEventListener('keydown', keyboardFocus, false);

    function pageScroll(current, header_height){
        $('html, body').animate({scrollTop: current.offset().top - header_height}, 700);
    }

    //accordeon
    $('.accordeon-title, .accordeon-button').on('click', function() {
        var $this = $(this),
            headerH = $('header').height(),
            $parentAccordeon = $this.closest('.accordeon'),
            $parentEntry = $this.closest('.accordeon-entry');

        if ($parentEntry.hasClass('active')) {
            $parentEntry
                .removeClass('active')
                .find('.accordeon-toggle')
                .slideUp();
        } else {
            $parentAccordeon
                .find('.accordeon-entry.active')
                .removeClass('active')
                .find('.accordeon-toggle')
                .slideUp();

            $parentEntry
                .addClass('active')
                .find('.accordeon-toggle')
                .slideDown(function() {
                pageScroll($parentEntry, headerH + 30);
            });
        }
    });

    //tabs pricing page
    var tabsFinish = 0;
    $('.tab-menu').on('click', function() {
        if($(this).hasClass('active') || tabsFinish) return false;

        tabsFinish = 1;

        // tabsWrapper.find('.tabs-title').text($(this).text()).removeClass('active');
        var $this = $(this),
            currentRel = $this.data('rel'),
            tabMenuWrap = $this.closest('.tab-menu-wrap'),
            tabsRel = tabMenuWrap.data('rel'),
            tabsWrapper = $('.tabs-output[data-rel="'+tabsRel+'"]'),
            tabsMenu = tabMenuWrap.find('li'),
            tabsItem = tabsWrapper.find('.tab-entry'),
            tabsItemToShow = tabsWrapper.find('.tab-entry[data-rel="'+currentRel+'"]');

        tabsItem.filter(':visible').fadeOut(function(){
            tabsItemToShow.fadeIn(function(){
                tabsFinish = 0;
            });
        });
        tabsMenu.removeClass('active');
        $this.parent().addClass('active');
    });

});