<!DOCTYPE html>
<html lang="uk">
<head>
    <? include '_top.php';?>
    <title>Eurobud - Product detail</title>
</head>
<body>
<!-- LOADER -->
<div id="loader-wrapper"></div>

<div id="content-block">
    <!-- HEADER -->
    <header class="header without-banner">
        <? include '_header.php';?>
    </header>

    <!-- MAIN CONTENT -->
    <main class="content">
        <div class="spacer-header"></div>

        <div class="section sp-bottom-sm-01 sp-top-bc">

            <div class="container">

                <ul class="breadcrumbs w-regular">
                    <li><a href="./index.php">головна</a></li>
                    <li><a href="./products-categories.php">продукція</a></li>
                    <li><a href="./products.php">сицилія</a></li>
                    <li><a href="./products.php">пінопласт</a></li>
                    <li><a href="#">Пінопласт Євробуд 25 Eko</a></li>
                </ul>


                <div class="row row-80 justify-content-center">
                    <div class="col-lg-7">
                        <div class="product-detail-image">
                            <div class="swiper-entry swiper-custom">
                                <div class="swiper-container"
                                     data-options='{"watchSlidesVisibility":true}'
                                >
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            <div class="product-detail-image-sn">
                                                <img src="./img/photo-product-001.png" alt="">
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="product-detail-image-sn">
                                                <img src="./img/photo-product-001.png" alt="">
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="product-detail-image-sn">
                                                <img src="./img/photo-product-001.png" alt="">
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="product-detail-image-sn">
                                                <img src="./img/photo-product-001.png" alt="">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="swiper-pagination style02"></div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="col-xl-5">

                        <div class="product-detail-info">
                            <h1 class="h3 xl w-bold product-detail-title">Пінопласт Євробуд 25 Eko</h1>
                            <div class="text">
                                <p>Плити пінополістирольні самозатухаючі «Євробуд 25 Eko» виготовляються виключно з іноземної сировини на сучасному європейському обладнанні. </p>
                                <p>Пінопласт виготовлений методом спінювання гранул полістиролу, формування у блоки, нарізки на плити і призначений для термоізоляції в системах, які створюють незначні механічні навантаження на утеплювач (витримує міцність на стиск при 10%-вій лінійній деформації</p>
                            </div>
                            <div class="product-detail-filter product-detail-filter-js">
                                <div class="title">Товщина</div>
                                <div class="item" data-price='32'>10см</div>
                                <div class="item"  data-price='36'>15см</div>
                                <div class="item"  data-price='48'>20см</div>
                                <div class="item active" data-price='56'>25см</div>
                            </div>
                            <div class="product-detail-price color-blue w-medium product-detail-price-js">
                                від <span>56</span> грн/м <sub>2</sub>
                            </div>
                            <button class="btn btn-secondary btn-block open-popup" data-rel="order-popup"><span>ЗАМОВИТИ</span></button>
                            <div class="text-center">
                                <button class="btn btn-toggle added">
                                    <span class="first"><span class="icon"><img src="./img/icon-0033.svg" alt=""></span><span>ДОДАТИ ДО ПОРІВНЯННЯ</span></span>
                                    <span class="second"><span class="icon"><img src="./img/icon-0022.svg" alt=""></span><span>ДОДАНО ДО ПОРІВНЯННЯ</span></span>
                                </button>
                            </div>
                        </div>
                        
                    </div>
                </div>
                
                
            </div>
            
        </div>
        
        <div class="section sp-bottom-xl">
            <div class="container">

                <div class="tabs-wrapper product-detail-tabs">
                    <div class="tab-nav">
                        <div class="tab-title">
                            <span>Переваги</span>
                            <i class="icon-arrow"></i>
                        </div>
                        <div class="tab-toggle">
                            <div class="active">Переваги</div>
                            <div>Відео</div>
                            <div>Характеристики</div>
                            <div>Застосування</div>
                            <div>Роботи</div>
                            <div>Документація</div>
                            <div>Гарантії</div>
                            <div>Серифікати</div>
                            <div>Креслення</div>
                        </div>
                    </div>
                    <div class="tab">

                        <div class="row justify-content-center">
                            <div class="col-xl-10">

                                <div class="h4 w-medium sp-title-bt-sm">Переваги продукту</div>
                                <div class="thumbnail-adv-wrap">
                                    <div class="thumbnail-adv">
                                        <span class="icon">
                                            <img src="./img/002-icon-adv.svg" alt="">
                                        </span>
                                        <div class="h6 w-medium title">Гарантія на пінопласт 50 років</div>
                                        <div class="text">
                                            <p>Завдяки новому сучасному обладнанню, прямим поставкам іноземної сировини  </p>
                                        </div>
                                    </div>
                                    <div class="thumbnail-adv">
                                        <span class="icon">
                                            <img src="./img/003-icon-adv.svg" alt="">
                                        </span>
                                        <div class="h6 w-medium title">Європейська сировина</div>
                                        <div class="text">
                                            <p>Завдяки новому сучасному обладнанню, прямим поставкам іноземної сировини  </p>
                                        </div>
                                    </div>
                                    <div class="thumbnail-adv">
                                        <span class="icon">
                                            <img src="./img/005-icon-adv.svg" alt="">
                                        </span>
                                        <div class="h6 w-medium title">Інноваційне обладнання</div>
                                        <div class="text">
                                            <p>Завдяки новому сучасному обладнанню, прямим поставкам іноземної сировини  </p>
                                        </div>
                                    </div>
                                    <div class="thumbnail-adv">
                                        <span class="icon">
                                            <img src="./img/004-icon-adv.svg" alt="">
                                        </span>
                                        <div class="h6 w-medium title">Транспортування</div>
                                        <div class="text">
                                            <p>Завдяки новому сучасному обладнанню, прямим поставкам іноземної сировини  </p>
                                        </div>
                                    </div>
                                    <div class="thumbnail-adv">
                                        <span class="icon">
                                            <img src="./img/001-icon-adv.svg" alt="">
                                        </span>
                                        <div class="h6 w-medium title">Заміна браку</div>
                                        <div class="text">
                                            <p>Завдяки новому сучасному обладнанню, прямим поставкам іноземної сировини  </p>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        
                    </div>
                    <div class="tab" style="display: none;">

                        <div class="row justify-content-center">
                            <div class="col-xl-10">

                                <div class="h4 w-medium sp-title-bt-sm">Відео продукту</div>
                                <div class="thumbnail-video-wrap">
                                
                                    <div class="thumbnail-video open-video open-popup" data-video-src="https://www.youtube.com/embed/L7OLY4HCctQ?autoplay=1" data-rel="video-popup">
                                        <div class="bg" data-bg='./img/video-image-1.jpg'></div>
                                        <div class="play-btn"></div>
                                    </div>

                                    <div class="thumbnail-video open-video open-popup" data-video-src="https://www.youtube.com/embed/L7OLY4HCctQ?autoplay=1" data-rel="video-popup">
                                        <div class="bg" data-bg='./img/video-image-2.jpg'></div>
                                        <div class="play-btn"></div>
                                    </div>

                                    <div class="thumbnail-video open-video open-popup " data-video-src="https://www.youtube.com/embed/L7OLY4HCctQ?autoplay=1" data-rel="video-popup">
                                        <div class="bg" data-bg='./img/video-image-3.jpg'></div>
                                        <div class="play-btn"></div>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                    <div class="tab" style="display: none;">

                        <div class="row justify-content-center">
                            <div class="col-xl-10">

                                
                                <div class="h4 w-medium sp-title-bt-sm">Характеристики</div>
                                <div class="text">
                                    <p>Компанія «Євробуд» постійно вивчає технологію застосування пінополістиролу в Європі, а тому, згідно норм діючих в Україні та Європейських норм, рекомендуємо обирати утеплювач відповідної марки товщиною від 10 см до 20 см, залежно від типу, матеріалу, товщини стін та перекриттів, а також функціонального призначення об’єктів, що утеплюються (промислові, житлові, холодильні камери тощо.)</p>
                                </div>              
                                <div class="table-style-01 last-two-bg color-secondary w-regular mr-dt">
                                      
                                    <table>
                                        <thead>
                                            <tr>
                                                <th>EPS S</th>
                                                <th></th>
                                                <th>Мін.вага пачки 0.3</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td>Коефіцієнт теплопровідності, Вт/(мк)</td>
                                                <td>7</td>
                                                <td>2,10</td>
                                            </tr>
                                            <tr>
                                                <td>Міцність при стиску при 10%, лінійній деформації, кпа ,Сs(10), kpa></td>
                                                <td>9</td>
                                                <td>3,12</td>
                                            </tr>
                                            <tr>
                                                <td>Міцність при згині, кпаб bs, kpa</td>
                                                <td>-</td>
                                                <td></td>
                                            </tr>
                                            <tr>
                                                <td>Щільність(густина)</td>
                                                <td>-</td>
                                                <td></td>
                                            </tr>
                                            <tr>
                                                <td>Міцність при розтягу перпендикулярнодо площини плити, кпа ,Сs(10), kpa></td>
                                                <td>0,049</td>
                                                <td></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-xl w-medium text-mr">
                                    <p>Площа та кількість пінополістирольних плит в упаковці в залежності від товщини (плити 1000 х 500 мм бічна кромка – рівна)</p>
                                </div>
                                <div class="table-style-01 color-secondary w-regular text-center">
                                    <table>
                                        <thead>
                                            <tr>
                                                <th>Товщина плити (см)</th>
                                                <th>Об’єм упаковки (м.куб.)</th>
                                                <th>Площа плит в упаковці (м.кв.)</th>
                                                <th>Кількість плит в упаковці (шт.)</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td>1</td>
                                                <td>0,3</td>
                                                <td>30</td>
                                                <td>30</td>
                                            </tr>
                                            <tr>
                                                <td>2</td>
                                                <td>0,3</td>
                                                <td>15</td>
                                                <td>60</td>
                                            </tr>
                                            <tr>
                                                <td>3</td>
                                                <td>0,28</td>
                                                <td>10</td>
                                                <td>25</td>
                                            </tr>
                                            <tr>
                                                <td>4</td>
                                                <td>0,27</td>
                                                <td>7,5</td>
                                                <td>15</td>
                                            </tr>
                                            <tr>
                                                <td>5</td>
                                                <td>0,3</td>
                                                <td>6</td>
                                                <td>12</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>

                        
                    </div>
                    <div class="tab" style="display: none;">

                        <div class="row justify-content-center">
                            <div class="col-xl-10">

                                <div class="text">
                                    <h4>Застосування продукту</h4>
                                    <p>Пінополістирольні плити використовують для звуко- і термоізоляції житлових, громадських та промислових будівель, як новобудов, так і перебувають в експлуатації. Основними параметрами, що визначають область застосування пінополістирольних плит, є здатність витримувати механічні навантаження і теплопровідність.</p>
                                    <p>Плити пінополістирольні «Євробуд 25 Eko» рекомендуємо застосовувати в системах, які створюють незначні механічні навантаження на утеплювач, (витримує міцність на стиск при 10%-ної лінійної деформації, не менше 30 кПа, межа міцності при згині, не менше 50 кПа ), а саме:</p>
                                    <ul>
                                        <li>зовнішня термоізоляція виконана методом «легким - сухим»;</li>
                                        <li>термоізоляція зовнішніх стін з облицюванням сайдингом, дошкою, профнастилом.</li>
                                        <li>термоізоляція у вентильованих і не вентильованих тришарових стінах;</li>
                                        <li>термоізоляція в зовнішніх і внутрішніх каркасних конструкціях;</li>
                                        <li>термоізоляція конструкцій внутрішніх стін і перегородок;</li>
                                        <li>нижнє утеплення перекриттів з облицюванням;</li>
                                        <li>термоізоляція легких каркасних перекриттів з облицюванням;</li>
                                        <li>термоізоляція простору між кроквами в похилих дахах;</li>
                                        <li>утеплення балконних лоджій;</li>
                                        <li>використовується в меблевій промисловості (упаковка) та при виробництві без каркасної меблів;</li>
                                        <li>використовується в машинобудуванні (утеплення автобусів, залізничних вагонів);</li>
                                        <li>інші звуко-і термоізоляції, в системах, які створюють незначні механічні навантаження на утеплювач.</li>
                                    </ul>
                                </div>

                            </div>
                        </div>
                        
                    </div>

                    <div class="tab" style="display: none;">

                        <div class="row justify-content-center">
                            <div class="col-xl-10">

                                <div class="h4 w-medium sp-title-bt-sm">Роботи</div>
                                <div class="thumbnail-gallery-wrap">

                                    <div class="thumbnail-gallery lightgallery">
                                        <a href="./img/image-gallery-big-01.jpg" class="lightgallery-simple image"  data-sub-html='Готель Невада'>
                                            <img src="./img/photo-gallery.jpg" >
                                            <div class="counter-images">
                                                <span class="icon"><img src="./img/icon-ar-img.svg" alt=""></span>
                                                4 фото
                                            </div>
                                        </a>

                                        <div class="info">
                                            <a href="./img/image-gallery-big-01.jpg" class="lightgallery-simple h6 w-medium title" data-sub-html='Готель Невада'>Готель Невада</a>
                                        </div>

                                        <a class="lightgallery-simple" href="./img/image-gallery-big-02.jpg" data-sub-html='Готель Невада'></a>
                                    </div>

                                    <div class="thumbnail-gallery lightgallery">
                                        <a href="./img/image-gallery-big-01.jpg" class="image lightgallery-simple" data-sub-html='Приватний сектор Куликів'>
                                            <img src="./img/photo-gallery-02.jpg" alt="image">
                                            <div class="counter-images">
                                                <span class="icon"><img src="./img/icon-ar-img.svg" alt=""></span>
                                                4 фото
                                            </div>
                                        </a>
                                        <div class="info">
                                            <a href="./img/image-gallery-big-02.jpg" title="Готель Невада" class="h6 w-medium title lightgallery-simple" data-sub-html='Приватний сектор Куликів'>Приватний сектор Тернопільська область Куликів</a>
                                        </div>

                                        <a class="lightgallery-simple" href="./img/image-gallery-big-02.jpg" data-sub-html='Приватний сектор Куликів'></a>
                                    </div>

                                    <div class="thumbnail-gallery lightgallery">
                                        <a href="./img/image-gallery-big-01.jpg" class="image lightgallery-simple" data-sub-html='Приватний сектор Умань'>
                                            <img src="./img/photo-gallery-03.jpg" alt="image">
                                            <div class="counter-images">
                                                <span class="icon"><img src="./img/icon-ar-img.svg" alt=""></span>
                                                4 фото
                                            </div>
                                        </a>
                                        <div class="info">
                                            <a href="./img/image-gallery-big-02.jpg" data-sub-html='Приватний сектор Умань' class="h6 w-medium title lightgallery-simple">Приватний сектор Умань</a>
                                        </div>

                                        <a class="lightgallery-simple" href="./img/image-gallery-big-02.jpg" data-sub-html='Приватний сектор Умань'></a>
                                    </div>

                                    <div class="thumbnail-gallery lightgallery">
                                        <a href="./img/image-gallery-big-01.jpg" class="image lightgallery-simple" data-sub-html='Приватний сектор Умань'>
                                            <img src="./img/photo-gallery-03.jpg" alt="image">
                                            <div class="counter-images">
                                                <span class="icon"><img src="./img/icon-ar-img.svg" alt=""></span>
                                                4 фото
                                            </div>
                                        </a>
                                        <div class="info">
                                            <a href="./img/image-gallery-big-02.jpg" data-sub-html='Приватний сектор Умань' class="h6 w-medium title lightgallery-simple">Приватний сектор Умань</a>
                                        </div>

                                        <a class="lightgallery-simple" href="./img/image-gallery-big-02.jpg" data-sub-html='Приватний сектор Умань'></a>
                                    </div>
                                </div>

                            </div>
                        </div>
                        
                    </div>

                    <div class="tab" style="display: none;">

                        <div class="row justify-content-center">
                            <div class="col-xl-10">

                                <div class="h4 w-medium sp-title-bt-sm">Документація</div>
                                <div class="text mr-bt-sm">
                                    <p>Для якісного виконання робіт та отримання максимального ефекту повинні бути обрані правильний метод утеплення, якісні аксесуари та супутні матеріали, а також кваліфіковані працівники.</p>
                                </div>
                                <div class="thumbnail-doc-wrap">

                                    <div class="thumbnail-doc">
                                        <span class="icon">
                                            <img src="./img/icon-PDF.svg" alt="icon" >
                                        </span>
                                        <a class="title w-medium" href="./file/file.pdf" target="_blank">
                                            Протокол горючості Г1 №208/1-2018 на плити пінополістирольні ПСБ-С-25 EPS 80 виробництва 
                                        </a>
                                        <div class="size">35.67 КБ</div>
                                    </div>
                                    <div class="thumbnail-doc">
                                        <span class="icon">
                                            <img src="./img/icon-PDF.svg" alt="icon" >
                                        </span>
                                        <a class="title w-medium" href="./file/file.pdf" target="_blank">
                                            Протокол горючості Г1 №209/1-2018 на плити 
                                        </a>
                                        <div class="size">289.67 КБ</div>
                                    </div>
                                    <div class="thumbnail-doc">
                                        <span class="icon">
                                            <img src="./img/icon-PDF.svg" alt="icon" >
                                        </span>
                                        <a class="title w-medium" href="./file/file.pdf" target="_blank">
                                            Протокол №10к/14 кваліфікаційних випробувань 
                                        </a>
                                        <div class="size">35.67 КБ</div>
                                    </div>
                                    <div class="thumbnail-doc">
                                        <span class="icon">
                                            <img src="./img/icon-PDF.svg" alt="icon" >
                                        </span>
                                        <a class="title w-medium" href="./file/file.pdf" target="_blank">
                                            Протокол горючості Г1 №208/1-2018 на плити пінополістирольні  
                                        </a>
                                        <div class="size">35.67 КБ</div>
                                    </div>
                                    <div class="thumbnail-doc">
                                        <span class="icon">
                                            <img src="./img/icon-PDF.svg" alt="icon" >
                                        </span>
                                        <a class="title w-medium" href="./file/file.pdf" target="_blank">
                                            Протокол горючості Г1 №209/1-2018 на плити пінополістирольні ПСБ-С-35 EPS 150 виробництва ТзОВ  
                                        </a>
                                        <div class="size">35.67 КБ</div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        
                    </div>

                    <div class="tab" style="display: none;">
                        
                        <div class="row justify-content-center">
                            <div class="col-xl-10">

                                <div class="h4 w-medium sp-title-bt-sm">Гарантії</div>
                                <div class="text">
                                    <p>Компанія «Євробуд» гарантує якість пінополістирольних плит при дотриманні умов транспортування, зберігання та вказівок щодо застосування.</p>
                                </div>

                            </div>
                        </div>

                        
                    </div>

                    <div class="tab" style="display: none;">

                        <div class="row justify-content-center">
                            <div class="col-xl-10">

                                <div class="h4 w-medium sp-title-bt-sm">Сертифікати</div>
                                <div class="text mr-bt-sm">
                                    <p>Компанія «Євробуд» гарантує якість пінополістирольних плит при дотриманні умов транспортування, зберігання та вказівок щодо застосування.</p>
                                </div>
                                <div class="thumbnail-ser-wrap">

                                    <div class="thumbnail-ser lightgallery">
                                        <a class="image lightgallery-simple" href="./img/image-doc-002.jpg">
                                            <img src="./img/image-doc-002.jpg" alt="doc">
                                        </a>
                                        <a class="title color-dark w-medium lightgallery-simple" href="./img/image-doc-002.jpg">
                                            Eurodach - product perfomance guarantee
                                        </a>
                                    </div>
                                    <div class="thumbnail-ser lightgallery">
                                        <a class="image lightgallery-simple" href="./img/image-doc-001.jpg">
                                            <img src="./img/image-doc-002.jpg" alt="doc">
                                        </a>
                                        <a class="title color-dark w-medium lightgallery-simple" href="./img/image-doc-001.jpg">
                                            Certyfikat SZBiHP OHSAS W PL
                                        </a>
                                    </div>
                                    <div class="thumbnail-ser lightgallery">
                                        <a class="image lightgallery-simple" href="./img/image-doc-001.jpg">
                                            <img src="./img/image-doc-001.jpg" alt="doc">
                                        </a>
                                        <a class="title color-dark w-medium lightgallery-simple" href="./img/image-doc-001.jpg">
                                            Certyfikat SZBiHP OHSAS W PL
                                        </a>
                                    </div>
                                    <div class="thumbnail-ser lightgallery">
                                        <a class="image lightgallery-simple" href="./img/image-doc-002.jpg">
                                            <img src="./img/image-doc-001.jpg" alt="doc">
                                        </a>
                                        <a class="title color-dark w-medium lightgallery-simple" href="./img/image-doc-001.jpg">
                                            Протокол горючості Г1 №208/1-2018
                                        </a>
                                    </div>
                                    <div class="thumbnail-ser lightgallery">
                                        <a class="image lightgallery-simple" href="./img/image-doc-001.jpg">
                                            <img src="./img/image-doc-001.jpg" alt="doc">
                                        </a>
                                        <a class="title color-dark w-medium lightgallery-simple" href="./img/image-doc-001.jpg">
                                            Eurodach - product perfomance guarantee
                                        </a>
                                    </div>
                                    <div class="thumbnail-ser lightgallery">
                                        <a class="image lightgallery-simple" href="./img/image-doc-002.jpg">
                                            <img src="./img/image-doc-001.jpg" alt="doc">
                                        </a>
                                        <a class="title color-dark w-medium lightgallery-simple" href="./img/image-doc-001.jpg">
                                            Eurodach - product perfomance guarantee
                                        </a>
                                    </div>                       
                                </div>

                            </div>
                        </div>
                        
                    </div>

                    <div class="tab" style="display: none;">

                        <div class="row justify-content-center">
                            <div class="col-xl-10">
                                
                                <div class="h4 w-medium sp-title-bt-sm">Креслення по монтажних роботах</div>
                                <div class="row align-items-center">
                                    <div class="col-lg-6 order-lg-first order-last">
                                        <div class="text list-style-01 w-regular">
                                            <ol>
                                                <li>Стіна, що утеплюється.</li>
                                                <li>Плити утеплювача</li>
                                                <li>Клеючий розчин</li>
                                                <li>Армуюча сітка</li>
                                                <li>Армуючий розчин</li>
                                                <li>Дюбель для закріплення плит утеплювача</li>
                                                <li>Алюмінієвий куток 25x25 з перфорованою стінкою</li>
                                                <li>Силіконова мастика</li>
                                            </ol>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 order-xl-last order-first">
                                        <div class="text-center">
                                            <img src="./img/img-content-01.jpg" alt="image">
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        
                    </div>
                </div>


            </div>
        </div>

        <div class="section sp-bottom-xl">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="h3 w-medium sp-title-bt">Корисні статті</div>

                        <div class="thumbnail-articles-wrap">

                            <div class="thumbnail-articles">
                                <a class="image" href="./useful-information-detail.php">
                                    <img src="./img/photo-articals-01.jpg" alt="">
                                </a>
                                <div class="info">
                                    <a href="./useful-information-detail.php" class="h5 w-medium title">Як обрати марку пінопласту?</a>
                                    <a href="./useful-information-detail.php" class="btn-3">
                                        <span>ДЕТАЛЬНІШЕ</span>
                                        <span class="arrow"></span>
                                    </a>
                                </div>
                            </div>

                            <div class="thumbnail-articles">
                                <a class="image" href="./useful-information-detail.php">
                                    <img src="./img/photo-articals-02.jpg" alt="">
                                </a>
                                <div class="info">
                                    <a href="./useful-information-detail.php" class="h5 w-medium title">Як обрати товщину пінопласту? Як обрати товщину пінопласту?</a>
                                    <a href="./useful-information-detail.php" class="btn-3">
                                        <span>ДЕТАЛЬНІШЕ</span>
                                        <span class="arrow"></span>
                                    </a>
                                </div>
                            </div>

                        </div>
                        
                    </div>
                </div>
            </div>
        </div>


        <div class="section sp-bottom-xl">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="h3 w-medium sp-title-bt">Питання відповіді</div>
                        <div class="acc-item style01">
                            <div class="acc-head">
                                <div class="caption">Як обрати товщину пінопласту?</div>
                                <div class="arrow">
                                    <svg width="18" height="10" viewBox="0 0 18 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1 1L9.25806 9L17 1" stroke-width="1.3"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="acc-body">Для якісного виконання робіт та отримання максимального ефекту повинні бути обрані правильний метод утеплення, якісні аксесуари та супутні матеріали, а також кваліфіковані працівники.</div>
                        </div>
                        <div class="acc-item style01">
                            <div class="acc-head">
                                <div class="caption">Як довго буде служити поркиття з пінопласту?</div>
                                <div class="arrow">
                                    <svg width="18" height="10" viewBox="0 0 18 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1 1L9.25806 9L17 1" stroke-width="1.3"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="acc-body">Пінопласт виготовлений методом спінювання гранул полістиролу, формування у блоки</div>
                        </div>
                        <div class="acc-item style01">
                            <div class="acc-head">
                                <div class="caption">Як обарти надійте поркиття з пінопласту?</div>
                                <div class="arrow">
                                    <svg width="18" height="10" viewBox="0 0 18 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1 1L9.25806 9L17 1" stroke-width="1.3"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="acc-body">Пінопласт виготовлений методом спінювання гранул полістиролу, формування у блоки</div>
                        </div>
                        <div class="acc-item style01">
                            <div class="acc-head">
                                <div class="caption">Як довго буде служити поркиття з пінопласту?</div>
                                <div class="arrow">
                                    <svg width="18" height="10" viewBox="0 0 18 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1 1L9.25806 9L17 1" stroke-width="1.3"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="acc-body">Пінопласт виготовлений методом спінювання гранул полістиролу, формування у блоки</div>
                        </div>
                        <div class="acc-item style01">
                            <div class="acc-head">
                                <div class="caption">Як обарти надійте поркиття з пінопласту?</div>
                                <div class="arrow">
                                    <svg width="18" height="10" viewBox="0 0 18 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1 1L9.25806 9L17 1" stroke-width="1.3"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="acc-body">Пінопласт виготовлений методом спінювання гранул полістиролу, формування у блоки</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        

        <div class="section sp-bottom-xl">
            <div class="container">
                <div class="row thumbnail-021-wrap">
                    <div class="col-xl-4 col-lg-6">
                        <a href="./dealers.php" class="thumbnail-021">
                            <img src="./img/photo-001.jpg" alt="">
                            <div class="info">
                                <div class="title h5 w-medium color-white">Гуртовий продаж</div>
                                <div class="btn-3">
                                    <span>ДЕТАЛЬНІШЕ</span>
                                    <span class="arrow white"></span>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-xl-4 col-lg-6">
                        <a href="./dealers.php" class="thumbnail-021">
                            <img src="./img/photo-002.jpg" alt="">
                            <div class="info">
                                <div class="title h5 w-medium color-white">Фірмові склади</div>
                                <div class="btn-3">
                                    <span>ДЕТАЛЬНІШЕ</span>
                                    <span class="arrow white"></span>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-xl-4 col-lg-6">
                        <a href="./dealers.php" class="thumbnail-021">
                            <img src="./img/photo-003.jpg" alt="">
                            <div class="info">
                                <div class="title h5 w-medium color-white">Дилери</div>
                                <div class="btn-3">
                                    <span>ДЕТАЛЬНІШЕ</span>
                                    <span class="arrow white"></span>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="section sp-bottom-xl">
            <div class="container">
                <div class="title-block style02">
                    <h2 class="h3 title w-bold">Інші товари</h2>
                </div>

                <div class="swiper-entry swiper-custom style01 sw-bt-sm slider-wrap-products">
                    <div class="swiper-container"
                         data-options='{
                              "watchSlidesVisibility": true,
                              "slidesPerView":4,
                              "autoHeight":true,
                              "breakpoints": {
                                  "1589": {"slidesPerView": 4},
                                  "1199": {"slidesPerView": 3},
                                  "991": {"slidesPerView": 2},
                                  "575": {"slidesPerView": 1}
                              }
                         }'
                    >
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <div class="product-1">
                                    <div class="promo-label new">новинка</div>
                                    <div class="product-1__top">
                                        <a href="#" class="product-1__img">
                                            <span class="first-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-01.jpg" alt="">
                                            </span>
                                            <span class="second-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-00234.jpg" alt="">
                                            </span>
                                        </a>
                                        <div class="hover-buttons">
                                            <div class="btn btn-4">ЗАМОВИТИ</div>

                                            <div class="btn btn-5 compare-button">
                                                <div class="icon">
                                                    <svg width="26" height="21" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 1.8858V.3624H9.6375L13 0l3.3624.3624h9.6376L26 1.8858h-3.047V3.991l3.0468 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8085 3.8086-2.1001 0-3.8086-1.7085-3.8086-3.8086v-.1798l3.0469-6.0937V1.8858h-7.6679v7.6171h1.5234v9.1406h4.5703v1.5234H6.1445v-1.5234h4.5703V9.5029h1.5234V1.8858H4.5703V3.991l3.0469 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8086 3.8086-2.1 0-3.8086-1.7085-3.8086-3.8086v-.1798L3.047 3.9911V1.8858H0zm22.1912 3.9884l-1.8144 3.6287h3.6288l-1.8144-3.6287zm0 6.6756c.993 0 1.8396-.6369 2.154-1.5235h-4.3079c.3144.8866 1.161 1.5235 2.1539 1.5235zm-8.4296 6.0937v-7.6172h-1.5234v7.6172h1.5234zM14.2078.3624l-1.2079 1.792L11.792.3624h2.4158zM3.8086 5.8742L1.9942 9.5029h3.6287L3.8086 5.8742zm0 6.6756c.993 0 1.8395-.6369 2.154-1.5235h-4.308c.3144.8866 1.161 1.5235 2.154 1.5235z"/></svg>
                                                </div>
                                                <span class="compare-inner">
                                                    <span class="icon-cm">
                                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1 1L13 13M1 13.0208L13.0208 1" stroke-width="1.6"/>
                                                        </svg>
                                                    </span>
                                                    <span>ДОДАНО</span>
                                                </span>
                                            </div>
                                            
                                        </div>
                                    </div>
                                    <div class="product-1__title">
                                        <a href="#" class="h6 title">Євробуд 25 Eko</a>
                                    </div>
                                    <div class="small-desc">Виготовляється на сучасному, повністю автоматизованому європейському обладнанні, яке відповідає найвищим </div>
                                    <div class="price">від <span>56</span> грн/шт</div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="product-1">
                                    <div class="product-1__top">
                                        <a href="#" class="product-1__img">
                                            <span class="first-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-02.jpg" alt="">
                                            </span>
                                            <span class="second-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-00234.jpg" alt="">
                                            </span>
                                        </a>
                                        <div class="hover-buttons">
                                            <div class="btn btn-4">ЗАМОВИТИ</div>

                                            <div class="btn btn-5 compare-button">
                                                <div class="icon">
                                                    <svg width="26" height="21" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 1.8858V.3624H9.6375L13 0l3.3624.3624h9.6376L26 1.8858h-3.047V3.991l3.0468 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8085 3.8086-2.1001 0-3.8086-1.7085-3.8086-3.8086v-.1798l3.0469-6.0937V1.8858h-7.6679v7.6171h1.5234v9.1406h4.5703v1.5234H6.1445v-1.5234h4.5703V9.5029h1.5234V1.8858H4.5703V3.991l3.0469 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8086 3.8086-2.1 0-3.8086-1.7085-3.8086-3.8086v-.1798L3.047 3.9911V1.8858H0zm22.1912 3.9884l-1.8144 3.6287h3.6288l-1.8144-3.6287zm0 6.6756c.993 0 1.8396-.6369 2.154-1.5235h-4.3079c.3144.8866 1.161 1.5235 2.1539 1.5235zm-8.4296 6.0937v-7.6172h-1.5234v7.6172h1.5234zM14.2078.3624l-1.2079 1.792L11.792.3624h2.4158zM3.8086 5.8742L1.9942 9.5029h3.6287L3.8086 5.8742zm0 6.6756c.993 0 1.8395-.6369 2.154-1.5235h-4.308c.3144.8866 1.161 1.5235 2.154 1.5235z"/></svg>
                                                </div>
                                                <span class="compare-inner">
                                                    <span class="icon-cm">
                                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1 1L13 13M1 13.0208L13.0208 1" stroke-width="1.6"/>
                                                        </svg>
                                                    </span>
                                                    <span>ДОДАНО</span>
                                                </span>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="product-1__title">
                                        <a href="#" class="h6 title">Євробуд 35 Gold</a>
                                    </div>
                                    <div class="small-desc">При замовленні плит товщиною від 11 см. до 60 см. кількість упаковок повинно бути кратно </div>
                                    <div class="price">від <span>56</span> грн/шт</div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="product-1">
                                    <div class="product-1__top">
                                        <a href="#" class="product-1__img">
                                            <span class="first-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-03.jpg" alt="">
                                            </span>
                                            <span class="second-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-06.jpg" alt="">
                                            </span>
                                        </a>
                                        <div class="hover-buttons">
                                            <div class="btn btn-4">ЗАМОВИТИ</div>

                                            <div class="btn btn-5 compare-button">
                                                <div class="icon">
                                                    <svg width="26" height="21" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 1.8858V.3624H9.6375L13 0l3.3624.3624h9.6376L26 1.8858h-3.047V3.991l3.0468 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8085 3.8086-2.1001 0-3.8086-1.7085-3.8086-3.8086v-.1798l3.0469-6.0937V1.8858h-7.6679v7.6171h1.5234v9.1406h4.5703v1.5234H6.1445v-1.5234h4.5703V9.5029h1.5234V1.8858H4.5703V3.991l3.0469 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8086 3.8086-2.1 0-3.8086-1.7085-3.8086-3.8086v-.1798L3.047 3.9911V1.8858H0zm22.1912 3.9884l-1.8144 3.6287h3.6288l-1.8144-3.6287zm0 6.6756c.993 0 1.8396-.6369 2.154-1.5235h-4.3079c.3144.8866 1.161 1.5235 2.1539 1.5235zm-8.4296 6.0937v-7.6172h-1.5234v7.6172h1.5234zM14.2078.3624l-1.2079 1.792L11.792.3624h2.4158zM3.8086 5.8742L1.9942 9.5029h3.6287L3.8086 5.8742zm0 6.6756c.993 0 1.8395-.6369 2.154-1.5235h-4.308c.3144.8866 1.161 1.5235 2.154 1.5235z"/></svg>
                                                </div>
                                                <span class="compare-inner">
                                                    <span class="icon-cm">
                                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1 1L13 13M1 13.0208L13.0208 1" stroke-width="1.6"/>
                                                        </svg>
                                                    </span>
                                                    <span>ДОДАНО</span>
                                                </span>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="product-1__title">
                                        <a href="#" class="h6 title">Модульна металочерепиця «Сицилія»</a>
                                    </div>
                                    <div class="small-desc">Металочерепиця невеликого розміру, довжиною в дві хвилі</div>
                                    <div class="price">від <span>56</span> грн/шт</div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="product-1">
                                    <div class="product-1__top">
                                        <a href="#" class="product-1__img">
                                            <span class="first-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-04.jpg" alt="">
                                            </span>
                                            <span class="second-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-06.jpg" alt="">
                                            </span>
                                        </a>
                                        <div class="hover-buttons">
                                            <div class="btn btn-4">ЗАМОВИТИ</div>

                                            <div class="btn btn-5 compare-button">
                                                <div class="icon">
                                                    <svg width="26" height="21" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 1.8858V.3624H9.6375L13 0l3.3624.3624h9.6376L26 1.8858h-3.047V3.991l3.0468 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8085 3.8086-2.1001 0-3.8086-1.7085-3.8086-3.8086v-.1798l3.0469-6.0937V1.8858h-7.6679v7.6171h1.5234v9.1406h4.5703v1.5234H6.1445v-1.5234h4.5703V9.5029h1.5234V1.8858H4.5703V3.991l3.0469 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8086 3.8086-2.1 0-3.8086-1.7085-3.8086-3.8086v-.1798L3.047 3.9911V1.8858H0zm22.1912 3.9884l-1.8144 3.6287h3.6288l-1.8144-3.6287zm0 6.6756c.993 0 1.8396-.6369 2.154-1.5235h-4.3079c.3144.8866 1.161 1.5235 2.1539 1.5235zm-8.4296 6.0937v-7.6172h-1.5234v7.6172h1.5234zM14.2078.3624l-1.2079 1.792L11.792.3624h2.4158zM3.8086 5.8742L1.9942 9.5029h3.6287L3.8086 5.8742zm0 6.6756c.993 0 1.8395-.6369 2.154-1.5235h-4.308c.3144.8866 1.161 1.5235 2.154 1.5235z"/></svg>
                                                </div>
                                                <span class="compare-inner">
                                                    <span class="icon-cm">
                                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1 1L13 13M1 13.0208L13.0208 1" stroke-width="1.6"/>
                                                        </svg>
                                                    </span>
                                                    <span>ДОДАНО</span>
                                                </span>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="product-1__title">
                                        <a href="#" class="h6 title">Металочерепиця «Вікторія»</a>
                                    </div>
                                    <div class="small-desc">Металочерепиця невеликого розміру, довжиною в дві хвилі</div>
                                    <div class="price">від <span>89</span> грн/шт</div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="product-1">
                                    <div class="product-1__top">
                                        <a href="#" class="product-1__img">
                                            <span class="first-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-05.jpg" alt="">
                                            </span>
                                            <span class="second-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-00234.jpg" alt="">
                                            </span>
                                        </a>
                                        <div class="hover-buttons">
                                            <div class="btn btn-4">ЗАМОВИТИ</div>

                                            <div class="btn btn-5 compare-button">
                                                <div class="icon">
                                                    <svg width="26" height="21" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 1.8858V.3624H9.6375L13 0l3.3624.3624h9.6376L26 1.8858h-3.047V3.991l3.0468 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8085 3.8086-2.1001 0-3.8086-1.7085-3.8086-3.8086v-.1798l3.0469-6.0937V1.8858h-7.6679v7.6171h1.5234v9.1406h4.5703v1.5234H6.1445v-1.5234h4.5703V9.5029h1.5234V1.8858H4.5703V3.991l3.0469 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8086 3.8086-2.1 0-3.8086-1.7085-3.8086-3.8086v-.1798L3.047 3.9911V1.8858H0zm22.1912 3.9884l-1.8144 3.6287h3.6288l-1.8144-3.6287zm0 6.6756c.993 0 1.8396-.6369 2.154-1.5235h-4.3079c.3144.8866 1.161 1.5235 2.1539 1.5235zm-8.4296 6.0937v-7.6172h-1.5234v7.6172h1.5234zM14.2078.3624l-1.2079 1.792L11.792.3624h2.4158zM3.8086 5.8742L1.9942 9.5029h3.6287L3.8086 5.8742zm0 6.6756c.993 0 1.8395-.6369 2.154-1.5235h-4.308c.3144.8866 1.161 1.5235 2.154 1.5235z"/></svg>
                                                </div>
                                                <span class="compare-inner">
                                                    <span class="icon-cm">
                                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1 1L13 13M1 13.0208L13.0208 1" stroke-width="1.6"/>
                                                        </svg>
                                                    </span>
                                                    <span>ДОДАНО</span>
                                                </span>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="product-1__title">
                                        <a href="#" class="h6 title">Євробуд 50 Gold</a>
                                    </div>
                                    <div class="small-desc">Завдяки новому сучасному обладнанню, прямим поставкам іноземної сировини </div>
                                    <div class="price">від <span>30</span> грн/шт</div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="product-1">
                                    <div class="promo-label new">новинка</div>
                                    <div class="product-1__top">
                                        <a href="#" class="product-1__img">
                                            <span class="first-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-01.jpg" alt="">
                                            </span>
                                            <span class="second-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-00234.jpg" alt="">
                                            </span>
                                        </a>
                                        <div class="hover-buttons">
                                            <div class="btn btn-4">ЗАМОВИТИ</div>

                                            <div class="btn btn-5 compare-button">
                                                <div class="icon">
                                                    <svg width="26" height="21" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 1.8858V.3624H9.6375L13 0l3.3624.3624h9.6376L26 1.8858h-3.047V3.991l3.0468 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8085 3.8086-2.1001 0-3.8086-1.7085-3.8086-3.8086v-.1798l3.0469-6.0937V1.8858h-7.6679v7.6171h1.5234v9.1406h4.5703v1.5234H6.1445v-1.5234h4.5703V9.5029h1.5234V1.8858H4.5703V3.991l3.0469 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8086 3.8086-2.1 0-3.8086-1.7085-3.8086-3.8086v-.1798L3.047 3.9911V1.8858H0zm22.1912 3.9884l-1.8144 3.6287h3.6288l-1.8144-3.6287zm0 6.6756c.993 0 1.8396-.6369 2.154-1.5235h-4.3079c.3144.8866 1.161 1.5235 2.1539 1.5235zm-8.4296 6.0937v-7.6172h-1.5234v7.6172h1.5234zM14.2078.3624l-1.2079 1.792L11.792.3624h2.4158zM3.8086 5.8742L1.9942 9.5029h3.6287L3.8086 5.8742zm0 6.6756c.993 0 1.8395-.6369 2.154-1.5235h-4.308c.3144.8866 1.161 1.5235 2.154 1.5235z"/></svg>
                                                </div>
                                                <span class="compare-inner">
                                                    <span class="icon-cm">
                                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1 1L13 13M1 13.0208L13.0208 1" stroke-width="1.6"/>
                                                        </svg>
                                                    </span>
                                                    <span>ДОДАНО</span>
                                                </span>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="product-1__title">
                                        <a href="#" class="h6 title">Євробуд 25 Eko</a>
                                    </div>
                                    <div class="small-desc">Завдяки новому сучасному обладнанню, прямим поставкам іноземної сировини</div>
                                    <div class="price">від <span>56</span> грн/шт</div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="product-1">
                                    <div class="product-1__top">
                                        <a href="#" class="product-1__img">
                                            <span class="first-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-02.jpg" alt="">
                                            </span>
                                            <span class="second-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-00234.jpg" alt="">
                                            </span>
                                        </a>
                                        <div class="hover-buttons">
                                            <div class="btn btn-4">ЗАМОВИТИ</div>

                                            <div class="btn btn-5 compare-button">
                                                <div class="icon">
                                                    <svg width="26" height="21" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 1.8858V.3624H9.6375L13 0l3.3624.3624h9.6376L26 1.8858h-3.047V3.991l3.0468 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8085 3.8086-2.1001 0-3.8086-1.7085-3.8086-3.8086v-.1798l3.0469-6.0937V1.8858h-7.6679v7.6171h1.5234v9.1406h4.5703v1.5234H6.1445v-1.5234h4.5703V9.5029h1.5234V1.8858H4.5703V3.991l3.0469 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8086 3.8086-2.1 0-3.8086-1.7085-3.8086-3.8086v-.1798L3.047 3.9911V1.8858H0zm22.1912 3.9884l-1.8144 3.6287h3.6288l-1.8144-3.6287zm0 6.6756c.993 0 1.8396-.6369 2.154-1.5235h-4.3079c.3144.8866 1.161 1.5235 2.1539 1.5235zm-8.4296 6.0937v-7.6172h-1.5234v7.6172h1.5234zM14.2078.3624l-1.2079 1.792L11.792.3624h2.4158zM3.8086 5.8742L1.9942 9.5029h3.6287L3.8086 5.8742zm0 6.6756c.993 0 1.8395-.6369 2.154-1.5235h-4.308c.3144.8866 1.161 1.5235 2.154 1.5235z"/></svg>
                                                </div>
                                                <span class="compare-inner">
                                                    <span class="icon-cm">
                                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1 1L13 13M1 13.0208L13.0208 1" stroke-width="1.6"/>
                                                        </svg>
                                                    </span>
                                                    <span>ДОДАНО</span>
                                                </span>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="product-1__title">
                                        <a href="#" class="h6 title">Євробуд 35 Gold</a>
                                    </div>
                                    <div class="small-desc">Пінопласт виготовлений методом спінювання гранул полістиролу, формування у блоки</div>
                                    <div class="price">від <span>56</span> грн/шт</div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="product-1">
                                    <div class="product-1__top">
                                        <a href="#" class="product-1__img">
                                            <span class="first-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-03.jpg" alt="">
                                            </span>
                                            <span class="second-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-06.jpg" alt="">
                                            </span>
                                        </a>
                                        <div class="hover-buttons">
                                            <div class="btn btn-4">ЗАМОВИТИ</div>

                                            <div class="btn btn-5 compare-button">
                                                <div class="icon">
                                                    <svg width="26" height="21" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 1.8858V.3624H9.6375L13 0l3.3624.3624h9.6376L26 1.8858h-3.047V3.991l3.0468 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8085 3.8086-2.1001 0-3.8086-1.7085-3.8086-3.8086v-.1798l3.0469-6.0937V1.8858h-7.6679v7.6171h1.5234v9.1406h4.5703v1.5234H6.1445v-1.5234h4.5703V9.5029h1.5234V1.8858H4.5703V3.991l3.0469 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8086 3.8086-2.1 0-3.8086-1.7085-3.8086-3.8086v-.1798L3.047 3.9911V1.8858H0zm22.1912 3.9884l-1.8144 3.6287h3.6288l-1.8144-3.6287zm0 6.6756c.993 0 1.8396-.6369 2.154-1.5235h-4.3079c.3144.8866 1.161 1.5235 2.1539 1.5235zm-8.4296 6.0937v-7.6172h-1.5234v7.6172h1.5234zM14.2078.3624l-1.2079 1.792L11.792.3624h2.4158zM3.8086 5.8742L1.9942 9.5029h3.6287L3.8086 5.8742zm0 6.6756c.993 0 1.8395-.6369 2.154-1.5235h-4.308c.3144.8866 1.161 1.5235 2.154 1.5235z"/></svg>
                                                </div>
                                                <span class="compare-inner">
                                                    <span class="icon-cm">
                                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1 1L13 13M1 13.0208L13.0208 1" stroke-width="1.6"/>
                                                        </svg>
                                                    </span>
                                                    <span>ДОДАНО</span>
                                                </span>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="product-1__title">
                                        <a href="#" class="h6 title">Модульна металочерепиця «Сицилія»</a>
                                    </div>
                                    <div class="small-desc">Металочерепиця невеликого розміру, довжиною в дві хвилі</div>
                                    <div class="price">від <span>56</span> грн/шт</div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="product-1">
                                    <div class="product-1__top">
                                        <a href="#" class="product-1__img">
                                            <span class="first-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-04.jpg" alt="">
                                            </span>
                                            <span class="second-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-06.jpg" alt="">
                                            </span>
                                        </a>
                                        <div class="hover-buttons">
                                            <div class="btn btn-4">ЗАМОВИТИ</div>

                                            <div class="btn btn-5 compare-button">
                                                <div class="icon">
                                                    <svg width="26" height="21" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 1.8858V.3624H9.6375L13 0l3.3624.3624h9.6376L26 1.8858h-3.047V3.991l3.0468 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8085 3.8086-2.1001 0-3.8086-1.7085-3.8086-3.8086v-.1798l3.0469-6.0937V1.8858h-7.6679v7.6171h1.5234v9.1406h4.5703v1.5234H6.1445v-1.5234h4.5703V9.5029h1.5234V1.8858H4.5703V3.991l3.0469 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8086 3.8086-2.1 0-3.8086-1.7085-3.8086-3.8086v-.1798L3.047 3.9911V1.8858H0zm22.1912 3.9884l-1.8144 3.6287h3.6288l-1.8144-3.6287zm0 6.6756c.993 0 1.8396-.6369 2.154-1.5235h-4.3079c.3144.8866 1.161 1.5235 2.1539 1.5235zm-8.4296 6.0937v-7.6172h-1.5234v7.6172h1.5234zM14.2078.3624l-1.2079 1.792L11.792.3624h2.4158zM3.8086 5.8742L1.9942 9.5029h3.6287L3.8086 5.8742zm0 6.6756c.993 0 1.8395-.6369 2.154-1.5235h-4.308c.3144.8866 1.161 1.5235 2.154 1.5235z"/></svg>
                                                </div>
                                                <span class="compare-inner">
                                                    <span class="icon-cm">
                                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1 1L13 13M1 13.0208L13.0208 1" stroke-width="1.6"/>
                                                        </svg>
                                                    </span>
                                                    <span>ДОДАНО</span>
                                                </span>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="product-1__title">
                                        <a href="#" class="h6 title">Металочерепиця «Вікторія»</a>
                                    </div>
                                    <div class="small-desc">Металочерепиця невеликого розміру, довжиною в дві хвилі</div>
                                    <div class="price">від <span>89</span> грн/шт</div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="product-1">
                                    <div class="product-1__top">
                                        <a href="#" class="product-1__img">
                                            <span class="first-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-05.jpg" alt="">
                                            </span>
                                            <span class="second-img img">
                                                <img src="img/preloader.jpg" data-i-src="img/product-00234.jpg" alt="">
                                            </span>
                                        </a>
                                        <div class="hover-buttons">
                                            <div class="btn btn-4">ЗАМОВИТИ</div>

                                            <div class="btn btn-5 compare-button">
                                                <div class="icon">
                                                    <svg width="26" height="21" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 1.8858V.3624H9.6375L13 0l3.3624.3624h9.6376L26 1.8858h-3.047V3.991l3.0468 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8085 3.8086-2.1001 0-3.8086-1.7085-3.8086-3.8086v-.1798l3.0469-6.0937V1.8858h-7.6679v7.6171h1.5234v9.1406h4.5703v1.5234H6.1445v-1.5234h4.5703V9.5029h1.5234V1.8858H4.5703V3.991l3.0469 6.0937v.1798c0 2.1001-1.7085 3.8086-3.8086 3.8086-2.1 0-3.8086-1.7085-3.8086-3.8086v-.1798L3.047 3.9911V1.8858H0zm22.1912 3.9884l-1.8144 3.6287h3.6288l-1.8144-3.6287zm0 6.6756c.993 0 1.8396-.6369 2.154-1.5235h-4.3079c.3144.8866 1.161 1.5235 2.1539 1.5235zm-8.4296 6.0937v-7.6172h-1.5234v7.6172h1.5234zM14.2078.3624l-1.2079 1.792L11.792.3624h2.4158zM3.8086 5.8742L1.9942 9.5029h3.6287L3.8086 5.8742zm0 6.6756c.993 0 1.8395-.6369 2.154-1.5235h-4.308c.3144.8866 1.161 1.5235 2.154 1.5235z"/></svg>
                                                </div>
                                                <span class="compare-inner">
                                                    <span class="icon-cm">
                                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1 1L13 13M1 13.0208L13.0208 1" stroke-width="1.6"/>
                                                        </svg>
                                                    </span>
                                                    <span>ДОДАНО</span>
                                                </span>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="product-1__title">
                                        <a href="#" class="h6 title">Євробуд 50 Gold</a>
                                    </div>
                                    <div class="small-desc">Завдяки новому сучасному обладнанню, прямим поставкам іноземної сировини </div>
                                    <div class="price">від <span>30</span> грн/шт</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="swiper-buttons">
                        <div class="swiper-button-prev arrow-btn left">
                            <div class="arrow"></div>
                        </div>
                        <div class="swiper-button-next arrow-btn right">
                            <div class="arrow"></div>
                        </div>
                    </div>

                    <div class="swiper-pagination swiper-pagination-relative style02"></div>
                </div>

                <div class="spacer-xl-60 spacer-md-30"></div>

                <div class="text-center">
                    <a href="./products.php" class="btn btn-primary blue">
                        <span>ПЕРЕГЛЯНУТИ ВСІ ТОВАРИ</span>
                        <span class="anim-border"></span>
                    </a>
                </div>
            </div>
        </div>


    </main>

    <!-- FOOTER -->
    <footer class="footer">
        <? include '_footer.php';?>
    </footer>

    <div class="wrapper-right-bt">
        <a href="./calculator.php" class="calculator">
            <div class="icon">
                <img src="img/preloader.jpg" data-i-src="img/calculator.svg" alt="">
            </div>
            <div class="text">калькулятор</div>
        </a>
    </div>

    <!-- <div class="cookie-message">
        <div class="cookie-message__inner">
            <div class="text">Перегляньте нашу <a href="#">Політику</a> щодо файлів cookie, щоб дізнатися більше.</div>
            <div class="btn-close style02"></div>
        </div>
    </div> -->

</div>

<!-- POPUPS -->
<div class="popup-wrapper">
    <div class="bg-layer"></div>
    <? include '_popups.php';?>
</div>

<? include '_bottom.php';?>
</body>
</html>